package com.yeejoin.amos.bank.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.yeejoin.amos.bank.common.enums.DeviceEnum;
import com.yeejoin.amos.bank.dao.IDeviceRecord;
import com.yeejoin.amos.bank.entity.DeviceRecord;
import com.yeejoin.amos.bank.entity.EquipmentQualityVo;
import com.yeejoin.amos.bank.entity.EquipmentVo;
import com.yeejoin.amos.bank.param.PointParam;
import com.yeejoin.amos.bank.remote.RemoteDeviceService;
import com.yeejoin.amos.bank.remote.client.DeviceRemoteClient;
import com.yeejoin.amos.bank.remote.client.RiskModelRemoteClient;
import com.yeejoin.amos.bank.service.IEquipmentService;
import com.yeejoin.amos.bank.utils.JsonUtil;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.spc.business.dao.mapper.EquipmentMapper;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.common.response.CoordDTO;
import com.yeejoin.amos.spc.core.common.response.Node3DVoResponse;
import com.yeejoin.amos.spc.exception.YeeException;

import fr.opensagres.xdocreport.template.velocity.internal.Foreach;

@Service
public class EquipmentServuceImpl2 implements IEquipmentService {

    @Autowired
    private RemoteDeviceService deviceService;
    
    @Autowired
    DeviceRemoteClient deviceClient;
    
    @Autowired
    EquipmentMapper mapper;
    
    @Autowired
    IDeviceRecord iDeviceRecord;
    
	@Autowired
    RiskModelRemoteClient riskModelRemoteClient;
    

    @Override
    public JSONArray queryEquipmentById(Long id, String type, String token) {
        Map<String, String> params = Maps.newHashMap();
        params.put("id", String.valueOf(id));
        String deviceDataGet = deviceDataGet = deviceService.selectEquipById(id);
        //String deviceDataGet = deviceService.deviceDoGetWithToken(DeviceUriEnum.根据设备id查询数据详情, token, params);
        JSONObject resJson = JSONObject.parseObject(deviceDataGet);
        String result = resJson.getString("result");
        if (null != result && "SUCCESS".equals(result)) {
            return resJson.getJSONArray("dataList");
        }

        return null;
    }

    @Override
    public Page<Object> queryEquipmentPortListById(Long id, CommonPageable commonPageable) {
        JSONArray content = JsonUtil.getJsonArray("portList.json");
        Page result = new PageImpl(content, commonPageable, 20);
        return result;
    }

    @Override
    public List<Object> queryNetwoerkInterfaceById(Long id) {
        JSONArray content = JsonUtil.getJsonArray("networkInterface.json");
        return content;
    }

    @Override
    public ArrayList<Node3DVoResponse> queryEqui3dData(String orgCode) {
        HashMap<String, String> params = Maps.newHashMap();
        params.put("orgCode", orgCode);
        params.put("model", "net_device");//网络设备

        String netDeviceResStr = deviceService.listByOrgCodeAndModel(orgCode, DeviceEnum.NET_DEVICE.getType());
        String serverResStr = deviceService.listByOrgCodeAndModel(orgCode, DeviceEnum.SERVER.getType());
        String patrolResStr = deviceService.listByOrgCodeAndModel(orgCode, DeviceEnum.PATROL.getType());
        String ipequipmentStr  =deviceService.listByOrgCodeAndModel(orgCode, DeviceEnum.IP_EQUIPMENT.getType());
        
        
        JSONObject ipequipmentStrjson = JSONObject.parseObject(ipequipmentStr);
        
        //String netDeviceResStr = deviceService.deviceDoGet(DeviceUriEnum.根据型号查询设备点, params);
        JSONObject netDeviceResJson = JSONObject.parseObject(netDeviceResStr);

        params.put("model", "server");//服务器
        //String serverResStr = deviceService.deviceDoGet(DeviceUriEnum.根据型号查询设备点, params);
        JSONObject serverResJson = JSONObject.parseObject(serverResStr);

        params.put("model", "patrol");//自动巡检设备
        //String patrolResStr = deviceService.deviceDoGet(DeviceUriEnum.根据型号查询设备点, params);
        JSONObject patrolResJson = JSONObject.parseObject(patrolResStr);

        if (!"SUCCESS".equals(netDeviceResJson.get("result")) || !"SUCCESS".equals(serverResJson.get("result"))
          || !"SUCCESS".equals(patrolResJson.get("result"))) {
            throw new YeeException("查询设备数据失败");
        }
        ArrayList<Node3DVoResponse> list = new ArrayList<>();
        //组装网络设备
        if (netDeviceResJson != null) {
            convertNode3DVoResponse(list, netDeviceResJson, "01");
//			List<JSONObject> equDataArray = (List<JSONObject>) netDeviceResJson.get("dataList");
//			equDataArray.forEach(e ->{
//				Node3DVoResponse node3dVoResponse = new Node3DVoResponse();
//				JSONObject paramsRes = e.getJSONObject("cfgParamJsonObject");
//				node3dVoResponse.setId(e.getString("id"));
////				node3dVoResponse.setIsDoor(paramsRes.getBoolean("isDoor"));
//				node3dVoResponse.setKey("equipment-" + e.getString("id"));
//				node3dVoResponse.setLabel(e.getString("name"));
//				node3dVoResponse.setTitle(e.getString("name"));
//				node3dVoResponse.setLevel("01");
//				node3dVoResponse.setLevelStr("impEqu_01");
//				node3dVoResponse.setObjType("01");
//				node3dVoResponse.setObjKey(paramsRes.getString("storey"));
//				node3dVoResponse.setSourceId(paramsRes.getString("sourceId"));
//				CoordDTO postion = new CoordDTO();
//				String positonStr = paramsRes.getString("position");
////				JSONArray positonArr = paramsRes.getJSONArray("position");
//				if(positonStr != null && positonStr.contains("{")) {
//					JSONObject parseObject = JSONObject.parseObject(positonStr);
//					postion.setX(parseObject.getDouble("x"));
//					postion.setY(parseObject.getDouble("y"));
//					postion.setZ(parseObject.getDouble("z"));
//				}else if(positonStr != null && !"".equals(positonStr)) {
//					String[] split = positonStr.split(",");
//					postion.setX(Double.valueOf(split[0]));
//					postion.setY(Double.valueOf(split[1]));
//					postion.setZ(Double.valueOf(split[2]));
//				}
//				node3dVoResponse.setPositionDTO(postion.toString());
//				node3dVoResponse.setPosition(postion);
//				node3dVoResponse.setRate(0);
//				node3dVoResponse.setRotation(new CoordDTO(0d, 0d, 0d));
//				node3dVoResponse.setRotationDTO(new CoordDTO(0d, 0d, 0d).toString());
//				node3dVoResponse.setScale(new CoordDTO(1d, 1d, 1d));
//				node3dVoResponse.setScaleDTO(new CoordDTO(1d, 1d, 1d).toString());
//				node3dVoResponse.setShowInfo(false);
//				node3dVoResponse.setTwinkle(false);
//				node3dVoResponse.setType("impEquipment");
//				list.add(node3dVoResponse);
//			});
        }
        //组装服务器
        if (serverResJson != null) {
            convertNode3DVoResponse(list, serverResJson, "02");
//			List<JSONObject> serverDataArray = (List<JSONObject>) serverResJson.get("dataList");
//			serverDataArray.forEach(e ->{
//				Node3DVoResponse node3dVoResponse = new Node3DVoResponse();
//				JSONObject paramsRes = e.getJSONObject("cfgParamJsonObject");
//				node3dVoResponse.setId(e.getString("id"));
////				node3dVoResponse.setIsDoor(paramsRes.getBoolean("isDoor"));
//				node3dVoResponse.setKey("equipment-" + e.getString("id"));
//				node3dVoResponse.setLabel(e.getString("name"));
//				node3dVoResponse.setTitle(e.getString("name"));
//				node3dVoResponse.setLevel("02");
//				node3dVoResponse.setLevelStr("impEqu_02");
//				node3dVoResponse.setObjType("02");
//				node3dVoResponse.setObjKey(paramsRes.getString("storey"));
//				node3dVoResponse.setSourceId(paramsRes.getString("sourceId"));
//				CoordDTO postion = new CoordDTO();
//				String positonStr = paramsRes.getString("position");
////				JSONArray positonArr = paramsRes.getJSONArray("position");
//				if(positonStr != null && positonStr.contains("{")) {
//					JSONObject parseObject = JSONObject.parseObject(positonStr);
//					postion.setX(parseObject.getDouble("x"));
//					postion.setY(parseObject.getDouble("y"));
//					postion.setZ(parseObject.getDouble("z"));
//				}else if(positonStr != null && !"".equals(positonStr)) {
//					String[] split = positonStr.split(",");
//					postion.setX(Double.valueOf(split[0]));
//					postion.setY(Double.valueOf(split[1]));
//					postion.setZ(Double.valueOf(split[2]));
//				}
//				node3dVoResponse.setPositionDTO(postion.toString());
//				node3dVoResponse.setPosition(postion);
//				node3dVoResponse.setRate(0);
//				node3dVoResponse.setRotation(new CoordDTO(0d, 0d, 0d));
//				node3dVoResponse.setRotationDTO(new CoordDTO(0d, 0d, 0d).toString());
//				node3dVoResponse.setScale(new CoordDTO(1d, 1d, 1d));
//				node3dVoResponse.setScaleDTO(new CoordDTO(1d, 1d, 1d).toString());
//				node3dVoResponse.setShowInfo(false);
//				node3dVoResponse.setTwinkle(false);
//				node3dVoResponse.setType("impEquipment");
//				list.add(node3dVoResponse);
//			});
        }

        //组装自动巡检设备
        if (patrolResJson != null) {
            convertNode3DVoResponse(list, patrolResJson, "03");
        }

        //IP 设备
        if (ipequipmentStrjson != null) {
            convertNode3DVoResponse(list, ipequipmentStrjson, "04");
        }

        
       

//        	 Node3DVoResponse node3dVoResponse = new Node3DVoResponse();
//             node3dVoResponse.setId("1");
//             node3dVoResponse.setKey("equipment-" +"1");
//             node3dVoResponse.setLabel("测试");
//             node3dVoResponse.setTitle("测试");
//             node3dVoResponse.setLevel("04");
//             node3dVoResponse.setLevelStr("impEqu_" + "04");
//             node3dVoResponse.setObjType("04");
//             node3dVoResponse.setObjKey("floor_3");
//             node3dVoResponse.setSourceId("1");
//             CoordDTO postion = new CoordDTO();                  
//             postion.setX(344.9619516812333);
//             postion.setY(93.90619659423828);
//             postion.setZ(154.7298426229343);
//             node3dVoResponse.setPositionDTO(postion.toString());
//             node3dVoResponse.setPosition(postion);
//             node3dVoResponse.setRate(0);
//             node3dVoResponse.setRotation(new CoordDTO(0d, 0d, 0d));
//             node3dVoResponse.setRotationDTO(new CoordDTO(0d, 0d, 0d).toString());
//             node3dVoResponse.setScale(new CoordDTO(1d, 1d, 1d));
//             node3dVoResponse.setScaleDTO(new CoordDTO(1d, 1d, 1d).toString());
//             node3dVoResponse.setShowInfo(false);
//             node3dVoResponse.setTwinkle(false);
//             node3dVoResponse.setType("impEquipment");
//             list.add(node3dVoResponse);
        
        
        
        
        return list;
    }


    private void convertNode3DVoResponse(ArrayList<Node3DVoResponse> list, JSONObject resJson, String type) {
        List<JSONObject> dataArray = (List<JSONObject>) resJson.get("dataList");
        dataArray.forEach(e -> {
            Node3DVoResponse node3dVoResponse = new Node3DVoResponse();
            JSONObject paramsRes = e.getJSONObject("cfgParamJsonObject");
            node3dVoResponse.setId(e.getString("id"));
//					node3dVoResponse.setIsDoor(paramsRes.getBoolean("isDoor"));
            node3dVoResponse.setKey("equipment-" + e.getString("id"));
            node3dVoResponse.setLabel(e.getString("name"));
            node3dVoResponse.setTitle(e.getString("name"));
            node3dVoResponse.setLevel(type);
            node3dVoResponse.setLevelStr("impEqu_" + type);
            node3dVoResponse.setObjType(type);
            node3dVoResponse.setObjKey(paramsRes.getString("storey"));
            node3dVoResponse.setSourceId(paramsRes.getString("sourceId"));
            CoordDTO postion = new CoordDTO();
            String positonStr = paramsRes.getString("position");
//					JSONArray positonArr = paramsRes.getJSONArray("position");
            if (positonStr != null && positonStr.contains("{")) {
                JSONObject parseObject = JSONObject.parseObject(positonStr);
                postion.setX(parseObject.getDouble("x"));
                postion.setY(parseObject.getDouble("y"));
                postion.setZ(parseObject.getDouble("z"));
            } else if (positonStr != null && !"".equals(positonStr)) {
                String[] split = positonStr.split(",");
                postion.setX(Double.valueOf(split[0]));
                postion.setY(Double.valueOf(split[1]));
                postion.setZ(Double.valueOf(split[2]));
            }
            node3dVoResponse.setPositionDTO(postion.toString());
            node3dVoResponse.setPosition(postion);
            node3dVoResponse.setRate(0);
            node3dVoResponse.setRotation(new CoordDTO(0d, 0d, 0d));
            node3dVoResponse.setRotationDTO(new CoordDTO(0d, 0d, 0d).toString());
            node3dVoResponse.setScale(new CoordDTO(1d, 1d, 1d));
            node3dVoResponse.setScaleDTO(new CoordDTO(1d, 1d, 1d).toString());
            node3dVoResponse.setShowInfo(false);
            node3dVoResponse.setTwinkle(false);
            node3dVoResponse.setType("impEquipment");
            list.add(node3dVoResponse);
        });
    }

	@Override
	public void syncDeviceList() {
		String listTxt = null;
		try {
			CommonResponse map = deviceClient.listDeviceAndDeviceCpblAttr(null);
			listTxt = JSONArray.toJSONString(map.getDataList()); 
			List<EquipmentVo> listDeviceAndDeviceCpblAttr = JSONArray.parseArray(listTxt, EquipmentVo.class);

			listDeviceAndDeviceCpblAttr = JSONObject.parseArray(listTxt, EquipmentVo.class);
			listDeviceAndDeviceCpblAttr.parallelStream().forEach(e -> {
				e.setCode(String.valueOf(e.getId()));
				mapper.insertEquipment(e);
				List<EquipmentQualityVo> qualityVo = e.getAttrs();
				qualityVo.parallelStream().forEach( i ->{
					    i.setCode(String.valueOf(i.getId()));
					    String nId = Long.toString(e.getId()) + Long.toString(i.getId());
					    i.setId(Long.parseLong(nId));
						i.setEquipmentId(e.getId());
						i.setRemark(i.getName());
						mapper.insertEquipmentAttrs(i);
					});

			});
			
		} catch (InnerInvokException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	@Override
	public List<DeviceRecord> selfDevice() {
		List<DeviceRecord> findAll = iDeviceRecord.findAll();
		return findAll;
	}

	@Override
	public Page queryEquimentRelation(CommonPageable commonPageable, String fname) {
		long total = mapper.querySelfDeviceCount(fname);
		List<DeviceRecord> list = mapper.querySelfDevice(commonPageable.getOffset(), commonPageable.getPageSize(), fname);
		return new PageImpl<>(list, commonPageable, total);
	}

	@Override
	public List<PointParam> handleEquipmentsPointData(Long factorId) throws InnerInvokException {
		 List<PointParam> list = new ArrayList<PointParam>();
		 CommonResponse queryBoundByFactroId = riskModelRemoteClient.listPointInputitemByFactorId(factorId);
		 List<Map> dataList = (List<Map>) queryBoundByFactroId.getDataList();
		 if(null !=dataList && dataList.size() > 0) {
			 for (Map map : dataList) {
				 //指标项
				 String equipmentPointNames = (String) map.get("equipmentPointNames");
				 String eqName = (String) map.get("equipmentName");
				 String[] split = equipmentPointNames.split("\n|\r");
				 for (int i = 0; i < split.length; i++) {
					PointParam param = new PointParam();
					String inputItemName = split[i];
					//检查项目是否合格
				    String identification = inputItemName.endsWith("##0")?"qualified":"unqualified";
				 	param.setFactorId(factorId);
					param.setIdentification(identification);
					param.setName(eqName);
					param.setType("device");
					param.setValue(inputItemName.substring(0, inputItemName.length()-3));
					list.add(param);
				 }
			 }
		 }
		 return list;
		
	}

	@Override
	public List<PointParam> handlePatrolPointData(Long factorId) throws InnerInvokException {
		 List<PointParam> list = new ArrayList<PointParam>();
		 CommonResponse queryBoundByFactroId = riskModelRemoteClient.queryBoundByFactroId(factorId);
		 List<Map> dataList = (List<Map>) queryBoundByFactroId.getDataList();
		 if(null !=dataList && dataList.size() > 0) {
			 for (Map map : dataList) {
				 //指标项
				 
				 String inputItems = (String) map.get("inputItems");
				 String patrolName = (String) map.get("pointName");
				 String[] split = inputItems.split("\n|\r");
				 for (int i = 0; i < split.length; i++) {
					//检查项名称
					PointParam param = new PointParam();
					String inputItemName = split[i];
					//检查项目是否合格
					String identification = inputItemName.endsWith("##0")?"qualified":"unqualified";
					param.setFactorId(factorId);
					param.setIdentification(identification);
					param.setName(patrolName);
					param.setType("patrol");
					param.setValue(inputItemName.substring(0, inputItemName.length()-3));
					list.add(param);
				 }
					
			}
		 }
		 return list;
		
	}

	@Override
	public Map<String, List> handlePointDatas(Long factorId) throws InnerInvokException {
		Map<String, List> map = new HashMap<>();
		List<PointParam> handlePatrolPointData = handlePatrolPointData(factorId);
		List<PointParam> handleEquipmentsPointData = handleEquipmentsPointData(factorId);
		map.put("patrol", handlePatrolPointData);
		map.put("device", handleEquipmentsPointData);
		return map;
	
    }

}
