package com.yeejoin.amos.bank.service.impl;

import com.yeejoin.amos.bank.dao.MaintenanceDutyDao;
import com.yeejoin.amos.bank.dao.mapper.MaintenanceDutyMapper;
import com.yeejoin.amos.bank.dao.mapper.mo.MaintenanceDutyMo;
import com.yeejoin.amos.bank.entity.MaintenanceDuty;
import com.yeejoin.amos.bank.service.MaintenanceDutyService;
import com.yeejoin.amos.op.core.jpa.GenericManagerImpl;
import com.yeejoin.amos.op.core.jpa.IBaseRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: xinglei
 * @Description:
 * @Date: 2019/12/9 16:38
 */
@Service("dutyService")
public class MaintenanceDutyServiceImpl extends GenericManagerImpl<MaintenanceDuty, Long> implements MaintenanceDutyService {
    public MaintenanceDutyServiceImpl(IBaseRepository<MaintenanceDuty, Long> repository) {
        super(repository);
    }
    
    @Autowired
    private MaintenanceDutyMapper dutyMapper;

    @Autowired
    private MaintenanceDutyDao dutyDao;

    @Override
    public List<MaintenanceDuty> getTodayDuty() {
        List<MaintenanceDuty> dutyList = dutyDao.findAll();
        return dutyList;
    }

	@Override
	public HashMap<String, Object> getMiddleHeader() {
		HashMap<String, Object> queryLeaderData = dutyMapper.queryLeaderData();
		List<HashMap<String, Object>> secondPeople = dutyMapper.querySecondPeople();
		HashMap<String, Object> data = new HashMap<>();
		data.put("leader", queryLeaderData);
		data.put("second", secondPeople);
		return data;
	}

	@Override
	public HashMap<String, Object> middleTableList(Integer pageNumber, Integer pageSize) {
		Integer offset = (pageNumber-1) * pageSize;
		List<HashMap<String, Object>> content = dutyMapper.queryFristPeople(offset,pageSize);
		Integer total = dutyMapper.queryFristPeopleCount();
		HashMap<String, Object> data = new HashMap<>();
		data.put("content", content);
		data.put("total", total);
		return data;
	}
}
