package com.yeejoin.amos.bank.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

import com.yeejoin.amos.bank.dao.entity.Alarm;
import com.yeejoin.amos.bank.dao.repository.IAlarmRepository;
import com.yeejoin.amos.bank.service.IAlarmService;
import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.op.core.jpa.GenericManagerImpl;
import com.yeejoin.amos.spc.business.dao.mapper.InputItemMapper;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.util.query.BaseQuerySpecification;

@Service
public class spcAlarmServiceImpl extends GenericManagerImpl<Alarm, String>  implements IAlarmService {

	
	@Autowired
	private IAlarmRepository iAlarmDao;
	 @Autowired
	 private InputItemMapper inputMapper;
	public spcAlarmServiceImpl(IAlarmRepository repository) {
		super(repository);
		this.iAlarmDao = repository;
	}

	@Override
	public Page<Alarm> list(List<DaoCriteria> criterias, CommonPageable commonPageable) {
		 BaseQuerySpecification<Alarm> spec = new BaseQuerySpecification<>(criterias);
	        Page<Alarm> page = iAlarmDao.findAll(spec, commonPageable);       
	        return page;
	}

	@Override
	public void saveBatch(List<Alarm> alarms) {
		iAlarmDao.saveAll(alarms);
	}

	@Override
	public List<Alarm> findByQueryColumn(String queryColumn) {
		return iAlarmDao.selectByQueryColumn(queryColumn);
	}
	
	public List<Map<String, Object>> countnum(String code) {
		return iAlarmDao.countnum(code);
	}

	@Override
	public List<HashMap<String, Object>> getcountxd(String code) {
		// TODO Auto-generated method stub
		return inputMapper.getcountxd(code);
	}

	@Override
	public List<HashMap<String, Object>> getcountnum(String code) {
		// TODO Auto-generated method stub
		return inputMapper.getcountnum(code);
	}

	@Override
	public List<HashMap<String, Object>> getcountyc(String code) {
		// TODO Auto-generated method stub
		return inputMapper.getcountyc(code);
	}

	@Override
	public List<HashMap<String, Object>> getxuncount(String code) {
		// TODO Auto-generated method stub
		return inputMapper.getxuncount(code);
	}
}
