package com.yeejoin.amos.bank.utils;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration   //配置类注解，被自动扫描发现
@PropertySource("classpath:application.properties") //指明配置源文件位置
@ConfigurationProperties("param") //指明前缀
public class ParamsConfig {
	/** 后台h5s服务 url */
	private String remoteurl;
	
	private String remoteWebsocketUrl;

	public String getRemoteurl() {
		return remoteurl;
	}

	public void setRemoteurl(String remoteurl) {
		this.remoteurl = remoteurl;
	}

	public String getRemoteWebsocketUrl() {
		return remoteWebsocketUrl;
	}

	public void setRemoteWebsocketUrl(String remoteWebsocketUrl) {
		this.remoteWebsocketUrl = remoteWebsocketUrl;
	}
	
}
