package com.yeejoin.amos.bank.utils;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author: xinglei
 * @Description: TODO(树结构)
 * @Date: 2019/12/2 13:57
 */
public class TreeUtil {

    public static List<TreeDto> findTree(List<TreeDto> rootNode, List<TreeDto> mapList) {

        rootNode.forEach(x -> {
            List<TreeDto> childList = getChildNode(x.getId(), mapList);
            x.setChildren(childList);
        });
        return rootNode;
    }

    public static List<TreeDto> getChildNode(String id, List<TreeDto> allNode) {
        List<TreeDto> childList = new ArrayList<>();
        allNode.forEach(x -> {
            if (x.getParentId().equals(id)) {
                childList.add(x);
            }
        });
        childList.forEach(
                x -> {
                    List<TreeDto> childNode = getChildNode(x.getId(), allNode);
                    x.setChildren(childNode);
                    if (childNode.size() > 0) {
                        x.setIsLeaf("1");
                    } else {
                        x.setIsLeaf("0");
                    }
                }
        );

        childList.forEach(x -> x.setChildren(getChildNode(x.getId(), allNode)));
        if (childList.size() == 0) {
            return new ArrayList<>(0);
        }
        return childList;
    }
}
