package com.yeejoin.amos.bank.webSocket;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.bank.common.enums.AbnormalStateEnum;
import com.yeejoin.amos.bank.common.enums.AlarmPointEnum;
import com.yeejoin.amos.bank.common.enums.AlarmPointTypeEnum;
import com.yeejoin.amos.bank.dao.entity.Alarm;
import com.yeejoin.amos.bank.dao.entity.AlarmPoint;
import com.yeejoin.amos.bank.dao.repository.IAlarmRepository;
import com.yeejoin.amos.bank.remote.client.PatrolRemoteClient;
import com.yeejoin.amos.bank.service.IAlarmPointService;
import com.yeejoin.amos.bank.service.IAlarmService;
import com.yeejoin.amos.bank.service.ITopographyService;
import com.yeejoin.amos.bank.utils.HttpUtil;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.spc.exception.YeeException;

/**
 * 设备告警
 *
 * @author DELL
 */
public class AlarmWebSocketClient extends WebSocketClient {

    private static final Logger log = Logger.getLogger(AlarmWebSocketClient.class);

    private IAlarmPointService alarmPointService;
    private IAlarmService alarmService;
    private ITopographyService iTopographyService;
    private AmosWsClient client;
    private IAlarmRepository iAlarmDao;
    private static final String TAB = "\r\n";

//    @Value("${params.patrol}")
//    private String address;
    private PatrolRemoteClient patrolRemoteClient;
    
    private static ApplicationContext allpicationContext;
    
    public static void setAllpicationContext(ApplicationContext context) {
        allpicationContext = context;
    }

    public AlarmWebSocketClient(String url) throws URISyntaxException {
        super(new URI(url));
    }

    @Override
    public void onOpen(ServerHandshake shake) {
        log.info("AlarmWebSocketClient Shake hands......");
        for (Iterator<String> it = shake.iterateHttpFields(); it.hasNext(); ) {
            String key = it.next();
            log.info(key + ":" + shake.getFieldValue(key));
        }

        alarmPointService = (IAlarmPointService) allpicationContext.getBean(IAlarmPointService.class);
        iTopographyService = (ITopographyService) allpicationContext.getBean(ITopographyService.class);
        client = (AmosWsClient) allpicationContext.getBean(AmosWsClient.class);
        alarmService = (IAlarmService) allpicationContext.getBean(IAlarmService.class);
        patrolRemoteClient= (PatrolRemoteClient) allpicationContext.getBean(PatrolRemoteClient.class);
        iAlarmDao =(IAlarmRepository) allpicationContext.getBean(IAlarmRepository.class);
//		try {
//			Properties props = PropertiesLoaderUtils.loadAllProperties("application.properties");
//			address = (String) props.get("params.patrol");
//		} catch (IOException e) {
//			e.printStackTrace();
//		}
    }

    @Override
    @Transactional
    public void onMessage(String paramString) {
        try {
            log.info("Received message：" + paramString);
            JSONObject msgJson = JSONObject.parseObject(paramString);
            Long eqpId = msgJson.getLong("eqpId");
            if (null != eqpId) {
                String curStatus = msgJson.getString("currentState");
                synchronized (this) {

                    List<AlarmPoint> pointList = alarmPointService.selectPointTypeAndPointId(AlarmPointTypeEnum.设备.getCode(), eqpId);
                    if (AlarmPointEnum.已确认已清除.getName().equals(curStatus) || AlarmPointEnum.未确认已清除.getName().equals(curStatus)) {
                        alarmPointService.deleteItems(pointList);
                        log.info("Clear alarm data  ...success");
                        iTopographyService.sendAbnormal(msgJson.getString("sourceId"), 0);
                    } else {
                        if (null == pointList || pointList.size() == 0) {
                            String alramContent = msgJson.getString("describe");
                            //    					String eqpType = msgJson.getString("eqpType");
                            //    					String eqpType = msgJson.getString("1");

                            String eqpName = msgJson.getString("eqpName");
                            String equipmentAttrs = msgJson.getString("equipmentAttrs");
                            AlarmPoint alarmPoint = new AlarmPoint();
                            alarmPoint.setPointId(eqpId);
                            alarmPoint.setSourceId(msgJson.getString("sourceId"));
                            alarmPoint.setPointType(AlarmPointTypeEnum.设备.getCode());
                            alarmPoint.setUpdateDate(new Date());
                            alarmPoint.setContent(alramContent);
                            alarmPoint.setPointAttrs(equipmentAttrs);
                            alarmPoint.setPointName(eqpName);
                            alarmPointService.saveItem(alarmPoint);
                            log.info("Save alarm data    ...success");

                            //String url = address + "api/msgSubscribe/alarmNotification";
                            try {
								Map<String, Object> map = new HashMap<String, Object>();
								map.put("code", msgJson.getString("orgCode"));
								map.put("body", "告警源名称：" + eqpName + TAB + "告警信息" + alramContent);
								String stringJson = JSONObject.toJSONString(map);
								//HttpUtil.PostJson(url, stringJson);
								CommonResponse result = patrolRemoteClient.sendAlarmNotification(stringJson);
								log.info("手机推送告警信息...success");
							} catch (Exception e) {
								log.info("手机推送告警信息失败...fail" + e.getMessage());
							}
                        }
                        String alarmLevel = msgJson.getString("alarmLevel");
                        AbnormalStateEnum enum1 = AbnormalStateEnum.getEnum(alarmLevel);
                        iTopographyService.sendAbnormal(msgJson.getString("sourceId"), enum1 == null ? 0 : enum1.getCode());
                    }
                    //推送前端告警信息
                    Sort sort = new Sort(Sort.Direction.DESC, "updateDate");
                    List<AlarmPoint> alarms = alarmPointService.findAll(sort);
                    WebsocketParam param = new WebsocketParam("alarmPoint", JSON.toJSONString(alarms));
                    //client.sendMessage(param);
                    Properties props = PropertiesLoaderUtils.loadAllProperties("application.properties");
                    String url = (String) props.get("params.remoteWebsocketUrl") + "/generic/sendMessage";
                    HttpUtil.PostJson(url, JSON.toJSONString(param));
                    log.info("send websocekt info：" + param);

                    //告警记录
                    String queryColumn = msgJson.getString("sourceId") + "_" + msgJson.getString("alarmType");
                    List<Alarm> curAlarmList = alarmService.findByQueryColumn(queryColumn);
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    if (curAlarmList != null && curAlarmList.size() > 0) {
                        Alarm alarm = curAlarmList.get(0);
                        alarm.setUpdateDate(df.format(new Date()));
                        alarm.setCurrentState(msgJson.getString("currentState"));
                       // alarmService.save(alarm);
                        iAlarmDao.save(alarm);
                        log.info("Update alarm records ...success");
                    } else {
//					if (alarm == null || AlarmPointEnum.已确认已清除.getName().equals(curStatus) 
//							|| AlarmPointEnum.未确认已清除.getName().equals(curStatus)) {
                        Alarm alarm = new Alarm();
                        alarm.setSourceId(msgJson.getString("sourceId"));
                        alarm.setAlarmLevel(msgJson.getString("alarmLevel"));
                        alarm.setAlarmReason(msgJson.getString("alarmReason"));
                        alarm.setAlarmSourceIp(msgJson.getString("alarmSourceIp"));
                        alarm.setAlarmSourceName(msgJson.getString("alarmSourceName"));
                        alarm.setAlarmSourceType(msgJson.getString("alarmType"));
                        alarm.setClearDate(msgJson.getString("clearDate"));
                        alarm.setClearPerson(msgJson.getString("clearPerson"));
                        alarm.setContinueDate(msgJson.getString("continueDate"));
                        alarm.setCurrentState(msgJson.getString("currentState"));
                        alarm.setEnsureDate(msgJson.getString("ensureDate"));
                        alarm.setHappenDate(msgJson.getString("happenDate"));
                        alarm.setEnsurePerson(msgJson.getString("ensurePerson"));
                        alarm.setOrgCode(msgJson.getString("orgCode"));
                        alarm.setUpdateDate(df.format(new Date()));
                        alarm.setQueryColumn(queryColumn);
                        //alarmService.save(alarm);
                        iAlarmDao.save(alarm);
                        log.info("Save alarm records...success");
                    }
                }
            }else {
				throw new YeeException("eqpId 不能为空！！！");
			}
        } catch (Exception e) {
            log.info("*****************error**************************");
            log.info(e.getMessage());
        }
    }

    @Override
    public void onClose(int paramInt, String paramString, boolean paramBoolean) {
        log.info("shut down...");
    }

    @Override
    public void onError(Exception e) {
        log.info("abnormal" + e);

    }

    public static synchronized void synAlarmPoint() {
        System.out.println("-------------------device alarms Socket start-------------------------");
        try {
            Properties props = PropertiesLoaderUtils.loadAllProperties("application.properties");
            String alarmWebSocketClientUrl = (String) props.get("params.remoteWebsocketUrl") + "metricData?subData=alarm";
            AlarmWebSocketClient client = new AlarmWebSocketClient(alarmWebSocketClientUrl);
            client.connect();
            while (!client.getReadyState().equals(WebSocket.READYSTATE.OPEN)) {
                System.out.println("connecting..device----" + client.getReadyState());
            }
            System.out.println("build..." + alarmWebSocketClientUrl + " connected");
        } catch (URISyntaxException | IOException e) {
            e.printStackTrace();
        }
    }
}
