package com.yeejoin.amos.bank.webSocket;

import static org.hamcrest.CoreMatchers.nullValue;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.bank.common.enums.AbnormalStateEnum;
import com.yeejoin.amos.bank.common.enums.AlarmPointEnum;
import com.yeejoin.amos.bank.common.enums.AlarmPointTypeEnum;
import com.yeejoin.amos.bank.common.enums.AutoInspectionTypeEnum;
import com.yeejoin.amos.bank.common.enums.PMTSTypeEnum;
import com.yeejoin.amos.bank.common.enums.TopoGroupEnum;
import com.yeejoin.amos.bank.common.enums.TopoNodeTypeEnum;
import com.yeejoin.amos.bank.dao.entity.Alarm;
import com.yeejoin.amos.bank.dao.entity.AlarmPoint;
import com.yeejoin.amos.bank.dao.repository.IAlarmRepository;
import com.yeejoin.amos.bank.entity.AutoInspection;
import com.yeejoin.amos.bank.remote.client.PatrolRemoteClient;
import com.yeejoin.amos.bank.service.IAisleInfoService;
import com.yeejoin.amos.bank.service.IAlarmPointService;
import com.yeejoin.amos.bank.service.IAlarmService;
import com.yeejoin.amos.bank.service.IAutoInspectionService;
import com.yeejoin.amos.bank.service.ITopographyService;
import com.yeejoin.amos.bank.utils.HttpUtil;
import com.yeejoin.amos.bank.utils.JsonUtil;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.spc.exception.YeeException;

/**
 * 自动巡检告警
 * @author DELL
 *
 */
public class InspectionWebSocketClient extends WebSocketClient{
	
    private static final Logger log = Logger.getLogger(InspectionWebSocketClient.class);
	
	private IAutoInspectionService autoInspectionService;
	private ITopographyService iTopographyService;
	private IAisleInfoService aisleInfoService;
	private IAlarmPointService alarmPointService;
	private IAlarmService alarmService;
	private AmosWsClient client;
	private IAlarmRepository iAlarmDao;
	private static final String TAB = "\r\n";
	
	private PatrolRemoteClient patrolRemoteClient;
	
	//private String address;
	 
	private static ApplicationContext allpicationContext;
	public static void setAllpicationContext(ApplicationContext context){
        allpicationContext = context;
    }
	
	public InspectionWebSocketClient(String url) throws URISyntaxException {
        super(new URI(url));
    }
 
    @Override
    public void onOpen(ServerHandshake shake) {
        log.info("InspectionWebSocketClient Shake hands......");
        for(Iterator<String> it=shake.iterateHttpFields();it.hasNext();) {
            String key = it.next();
            log.info(key+":"+shake.getFieldValue(key));
        }
        autoInspectionService = (IAutoInspectionService) allpicationContext.getBean(IAutoInspectionService.class);
		iTopographyService = (ITopographyService) allpicationContext.getBean(ITopographyService.class);
		aisleInfoService = (IAisleInfoService) allpicationContext.getBean(IAisleInfoService.class);
		alarmPointService = (IAlarmPointService) allpicationContext.getBean(IAlarmPointService.class);
		alarmService = (IAlarmService) allpicationContext.getBean(IAlarmService.class);
		client = (AmosWsClient) allpicationContext.getBean(AmosWsClient.class);
		patrolRemoteClient= (PatrolRemoteClient) allpicationContext.getBean(PatrolRemoteClient.class);
		iAlarmDao =(IAlarmRepository) allpicationContext.getBean(IAlarmRepository.class);


		try {
			Properties props = PropertiesLoaderUtils.loadAllProperties("application.properties");
			//address = (String) props.get("params.patrol");
		} catch (IOException e) {
			e.printStackTrace();
		}
    }
 
    @Override
    @Transactional
    public void onMessage(String paramString) {
    	try {
    		log.info("Received message："+paramString);
    		String formatJsonString = JsonUtil.formatJsonString(paramString);
    		JSONObject msgJson = JSONObject.parseObject(formatJsonString);
    		if(msgJson != null) {
    			synchronized (this) {
    			String monitorItemName = msgJson.getString("monitorItemName");
    			String alarmState = msgJson.getString("alarmState");
    			String monitorHostMachine = msgJson.getString("monitorHostMachine");
    			String eqpId = msgJson.getString("eqpId");
					
    				if(monitorItemName != null && !"".equals(monitorItemName) && alarmState != null && !"".equals(alarmState)
    						&& eqpId != null && !"".equals(eqpId)) {
    					
    					
    					log.info("监控项名称：" + monitorItemName + " 发送设备： " + monitorHostMachine);
    					//查询自动巡检告警列表
    					List<AutoInspection> abnormals = autoInspectionService.findAbnormalByMonitorItemNameAndHost(monitorItemName,monitorHostMachine);
    					
    					if(abnormals != null && abnormals.size() > 0) {
    						log.info("告警列表：" + abnormals);
    						String nextCheckTime = msgJson.getString("nextCheckTime");
    						AutoInspection abnormalInspection = abnormals.get(abnormals.size()-1);
    						
    						//状态更新为正常时 发送websocket
    						Boolean sendMsg = false; 
    						if(!alarmState.equals(abnormalInspection.getAlarmState())) {
    							sendMsg = true;
    							//删除告警表
    							deleteAlarmPoint(eqpId,monitorItemName);
    						}else {
    							//更新告警信息
    							saveAlarmPoint(abnormalInspection, msgJson, eqpId);
    						}
    						abnormalInspection.setNextCheckTime(nextCheckTime);
    						abnormalInspection.setAlarmState(alarmState);
    						abnormalInspection.setCurrentCheckTime(msgJson.getString("currentCheckTime"));
    						abnormalInspection.setCurrentValue(msgJson.getString("currentValue"));
    						autoInspectionService.save(abnormalInspection);
    						log.info("异常[" + monitorItemName + "]点状态更新为"+ alarmState +"，下次检查时间"+ nextCheckTime +"...success");
    						saveSpcAlarm(abnormalInspection,msgJson);//保存告警记录
    						
    						if(sendMsg) {
    							String aisleType = abnormalInspection.getAisleType();
    							if( (AutoInspectionTypeEnum.商业银行通道.getType().equals(aisleType) 
    									|| AutoInspectionTypeEnum.NPC通道.getType().equals(aisleType))) {//通道   状态更新时
    								sendWebSocketMsg(abnormalInspection.getLabel1());
    								Long treeId = aisleInfoService.queryTreeIdByStratAndEnd(monitorHostMachine,abnormalInspection.getLabel2());
    								
    								iTopographyService.sendPMTSAbnormal(PMTSTypeEnum.getEnumType(monitorHostMachine)
    										,abnormalInspection.getLabel2()
    										,TopoGroupEnum.PMTS.getName()
    										,treeId,0);
    								log.info("topo图PMTS 通道状态更新信息发送成功...success");
    							}else if((AutoInspectionTypeEnum.MQ状态.getType().equals(aisleType) 
    										|| AutoInspectionTypeEnum.设备状态.getType().equals(aisleType))){//设备状态 更新
    								iTopographyService.sendAbnormalByType(monitorHostMachine, 
    															AbnormalStateEnum.N.getCode(), 
    															TopoNodeTypeEnum.设备监控.getType(),
    															monitorItemName);
	    							log.info("topo图设备监控更新信息发送成功...success");
    							}
    						}
    					}else {
    						
    						AutoInspection autoInspection = new AutoInspection();
    						autoInspection.setAlarmState(alarmState);
    						autoInspection.setMonitorItemName(monitorItemName);
    						autoInspection.setMonitorHostMachine(monitorHostMachine);
    						autoInspection.setMonitorPeriod(msgJson.getString("monitorPeriod"));
    						autoInspection.setMonitorType(msgJson.getString("monitorType"));
    						autoInspection.setNextCheckTime(msgJson.getString("nextCheckTime"));
    						autoInspection.setOrgCode(msgJson.getString("orgCode"));
    						autoInspection.setSourceId(msgJson.getString("sourceId"));
    						autoInspection.setCurrentCheckTime(msgJson.getString("currentCheckTime"));
    						autoInspection.setCurrentValue(msgJson.getString("currentValue"));
    						
    						ArrayList<String> aisleInfo = new ArrayList<>();
    						if(monitorItemName.contains("行号")) {
    							String[] splits = monitorItemName.split(" ");
    							if(splits.length > 0) {
    								autoInspection.setLabel1(monitorHostMachine);
    								autoInspection.setLabel2(splits[0].replace("行号", ""));
    								autoInspection.setAisle(splits[1]);
    								autoInspection.setAisleType(AutoInspectionTypeEnum.商业银行通道.getType());
    							}
    						}else if(monitorItemName.contains("到")) {
    							aisleInfo = getAisleInfo(monitorItemName,"到");
    							autoInspection.setAisleType(AutoInspectionTypeEnum.NPC通道.getType());
    							autoInspection.setLabel1(aisleInfo.get(0));
    							String label2 = aisleInfo.get(1);
    							String aisle = aisleInfo.get(2);
//    							label2 = aisle.contains("1") ? label2 + "1" : label2; 
    							autoInspection.setLabel2(label2);
    							autoInspection.setAisle(aisle);
    							log.info("设置通道信息Aisle:" + aisleInfo.get(2) + "Label1:"+ aisleInfo.get(0)+ "Label2:"+ aisleInfo.get(1));
    							
    						}else if(monitorItemName.contains("MQ系统")) {
    							autoInspection.setAisle("MQ系统");
    							autoInspection.setAisleType(AutoInspectionTypeEnum.MQ状态.getType());
    							String code = monitorItemName.replaceAll("[^a-zA-Z0-9]", "");//取英文数字
    							autoInspection.setLabel1(code);
    						}else {
    							autoInspection.setAisleType(AutoInspectionTypeEnum.设备状态.getType());
    						}
    						
    						autoInspectionService.save(autoInspection);
    						log.info("[" + monitorItemName + "]自动巡检状态["+ alarmState +"]，保存成功...success");
    						saveSpcAlarm(autoInspection,msgJson);//保存告警记录
    						
    						if(AlarmPointEnum.异常.getName().equals(alarmState)) {
    							saveAlarmPoint(autoInspection,msgJson,eqpId);
    							
    							String aisleType = autoInspection.getAisleType();
	    						if( (AutoInspectionTypeEnum.商业银行通道.getType().equals(aisleType) 
	    								|| AutoInspectionTypeEnum.NPC通道.getType().equals(aisleType))) {//通道   状态为异常时
	    							sendWebSocketMsg(autoInspection.getLabel1());
	    							
	    							Long treeId = aisleInfoService.queryTreeIdByStratAndEnd(monitorHostMachine,autoInspection.getLabel2());
	    							iTopographyService.sendPMTSAbnormal(PMTSTypeEnum.getEnumType(monitorHostMachine)
	    															,autoInspection.getLabel2()
	    															,TopoGroupEnum.PMTS.getName()
	    															,treeId
	    															,AbnormalStateEnum.M.getCode());
	    							log.info("topo图PMTS异常发送成功...success");
	    							
	    						}else if((AutoInspectionTypeEnum.MQ状态.getType().equals(aisleType) 
	    									|| AutoInspectionTypeEnum.设备状态.getType().equals(aisleType))) {//设备状态为异常时
	    							iTopographyService.sendAbnormalByType(monitorHostMachine, 
	    															AbnormalStateEnum.M.getCode(),
	    															TopoNodeTypeEnum.设备监控.getType(),
	    															monitorItemName);
	    							log.info("topo图设备监控异常发送成功...success");
	    						}
    						
    							//推送消息巡检app
      	    					//String url =address+"api/msgSubscribe/alarmNotification";
      	    					try {
									Map<String, Object> map=new HashMap<String, Object>();
									map.put("code", msgJson.getString("orgCode"));	    	    					
									map.put("body", "告警源名称："+monitorItemName+TAB+"告警信息"+alarmState);
									String stringJson = JSONObject.toJSONString(map);
    				   // HttpUtil.PostJson(url, stringJson);
									CommonResponse result = patrolRemoteClient.sendAlarmNotification(stringJson);
									log.info("手机推送告警信息...success");
								} catch (Exception e) {
									log.info("手机推送告警信息失败...fail" + e.getMessage());
								}
    						}
    					}
    					
    				}else {
    					throw new YeeException("监控项名/或告警状态/eqpId  不能为空！！！");
    				}
    				
				}
    			
    		}
    		
			
		} catch (Exception e) {
			log.info("*****************error**************************");
			log.info(e.getMessage());
		}
    }

	@Override
    public void onClose(int paramInt, String paramString, boolean paramBoolean) {
        log.info("shut down...");
    }
 
    @Override
    public void onError(Exception e) {
        log.info("abnormal"+e);
        
    }
    
    public static synchronized void synInspectionAlarm() {
    	System.out.println("-------------------Inspection alarms Socket start-------------------------");
        try {
        	Properties props = PropertiesLoaderUtils.loadAllProperties("application.properties");
        	String alarmWebSocketClientUrl = (String) props.get("params.remoteWebsocketUrl") + "metricData?subData=monitor";
        	InspectionWebSocketClient client = new InspectionWebSocketClient(alarmWebSocketClientUrl);
            client.connect();
            while (!client.getReadyState().equals(WebSocket.READYSTATE.OPEN)) {
            	System.out.println("Connecting..Inspection----"+ client.getReadyState());
            }
            System.out.println("build..." + alarmWebSocketClientUrl + " connected");
        } catch (URISyntaxException | IOException e) {
            e.printStackTrace();
        } 
    }
    
    
    private static ArrayList<String> getAisleInfo(String content,String replaceStr){
    	ArrayList<String> list = new ArrayList<>();
    	String replaceAll = content.replaceAll("[^a-zA-Z0-9]", "_");//取英文数字
    	String[] split = replaceAll.split("_");
    	list.add(split[0]);
    	list.add(split[1] + " " + split[split.length-1]);
    	String flagStr = split[1];
//    	//获取第二个英文数字后的值
    	String substring = content.substring(content.indexOf(flagStr), content.length()).replace(flagStr, "");
    	list.add(substring);
    	return list;
    }
    
    public static void main(String[] args) {
		String aaaString="791TB到NPC发送通道状态1F";
		String bbbString="791TB到NPC发送通道状态F";
		ArrayList<String> aisleInfo = getAisleInfo(aaaString,"");
    	System.out.println(aisleInfo);
    	ArrayList<String> bbb = getAisleInfo(bbbString,"");
    	System.out.println(bbb);
	}
    
    private void sendWebSocketMsg(String label) {
    	try {
			log.info("send websocekt start ");
			List<HashMap<String, Object>> aisleSummary = autoInspectionService.aisleSummary(null,label);
			List<JSONObject> topoAislelist = autoInspectionService.topoAislelist();
			HashMap<String, Object> data = new HashMap<>();
			data.put("index", aisleSummary);
			data.put("pams", topoAislelist);
			WebsocketParam param = new WebsocketParam("aisleAlarm", JSON.toJSONString(data));
			//client.sendMessage(param);
			Properties props = PropertiesLoaderUtils.loadAllProperties("application.properties");
			String url = (String) props.get("params.remoteWebsocketUrl") + "/generic/sendMessage";
			HttpUtil.PostJson(url, JSON.toJSONString(param));
			log.info("send websocekt finsh ... param ：" + param);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

    //告警表保存
	private void saveAlarmPoint(AutoInspection autoInspection, JSONObject msgJson,String eqpId) {
		String content = autoInspection.getMonitorItemName();
		List<AlarmPoint> pointList = alarmPointService.queryAutoInspection(eqpId,content);
		AlarmPoint alarmPoint = null;
		if(pointList != null && pointList.size()==0) {
			
			alarmPoint = new AlarmPoint();
			alarmPoint.setPointType(autoInspection.getAisleType().equals(AutoInspectionTypeEnum.NPC通道.getType()) 
					|| autoInspection.getAisleType().equals(AutoInspectionTypeEnum.商业银行通道.getType()) 
					? AlarmPointTypeEnum.通道.getCode() : AlarmPointTypeEnum.虚拟设备.getCode());
			alarmPoint.setUpdateDate(new Date());
			alarmPoint.setPointId(msgJson.getLong("eqpId") != null ? msgJson.getLong("eqpId") : 0);
			alarmPoint.setContent(autoInspection.getMonitorItemName());
			alarmPoint.setCode(msgJson.getString("orgCode") != null ? msgJson.getString("orgCode") : "");
			alarmPoint.setSourceId(msgJson.getString("sourceId") != null ? msgJson.getString("sourceId") : "");
			alarmPoint.setPointAttrs(msgJson.getString("equipmentAttrs") != null ? msgJson.getString("equipmentAttrs") : "");
			alarmPointService.save(alarmPoint);
			log.info("p_alarm_point 告警表保存成功...success");
			sendAlarmWebSocket();
			
		}else {
			alarmPoint = pointList.get(0);
			alarmPoint.setUpdateDate(new Date());
			alarmPointService.save(alarmPoint);
			log.info("p_alarm_point 告警表更新成功...success");
		}
	}
	
	//删除告警表信息
	private void deleteAlarmPoint(String eqpId,String content) {
		List<AlarmPoint> pointList = alarmPointService.queryAutoInspection(eqpId,content);
		if(pointList != null && pointList.size()>0) {
			alarmPointService.deleteItems(pointList);
		}
		log.info("删除告警点[eqpId:"+ eqpId +"]  p_alarm_point 成功...success");
		sendAlarmWebSocket();
	}
	
	//推送前端告警信息 跑马灯  
	private void sendAlarmWebSocket() {
        try {
			Sort sort = new Sort(Sort.Direction.DESC, "updateDate");
			List<AlarmPoint> alarms = alarmPointService.findAll(sort);
			WebsocketParam param = new WebsocketParam("alarmPoint", JSON.toJSONString(alarms));
      // client.sendMessage(param);
			Properties props = PropertiesLoaderUtils.loadAllProperties("application.properties");
			String url = (String) props.get("params.remoteWebsocketUrl") + "/generic/sendMessage";
			HttpUtil.PostJson(url, JSON.toJSONString(param));
			log.info("send websocekt info：" + param);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	private void saveSpcAlarm(AutoInspection autoInspection, JSONObject msgJson) {
		String columnString = msgJson.getString("eqpId") + "_" + autoInspection.getMonitorItemName();
		List<Alarm> spcAlarmList = alarmService.findByQueryColumn(columnString);
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Alarm alarm = null;
		if(spcAlarmList != null && spcAlarmList.size()>0) {
			alarm = spcAlarmList.get(0);
			alarm.setUpdateDate(df.format(new Date()));
			alarm.setCurrentState(autoInspection.getAlarmState());
			//alarmService.save(alarm);
			iAlarmDao.save(alarm);
			log.info("Update alarm records...success");
		}else {
			alarm = new Alarm();
			alarm.setSourceId(msgJson.getString("sourceId"));
			alarm.setAlarmLevel(AbnormalStateEnum.W.getName());
			alarm.setAlarmReason(autoInspection.getMonitorItemName());
			alarm.setAlarmSourceName(autoInspection.getMonitorHostMachine());
			alarm.setAlarmSourceType(AutoInspectionTypeEnum.getEnumName(autoInspection.getAisleType()));
			alarm.setCurrentState(autoInspection.getAlarmState());
			alarm.setOrgCode(msgJson.getString("orgCode"));
			alarm.setUpdateDate(df.format(new Date()));
			alarm.setQueryColumn(msgJson.getString("eqpId") + "_" + autoInspection.getMonitorItemName());
			//alarmService.save(alarm);
			iAlarmDao.save(alarm);
			log.info("Save alarm records...success");
		}
	}
	
	
	
}