package com.yeejoin.amos.spc.business.controller;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.param.ReginParams;
import com.yeejoin.amos.spc.business.service.intfc.ISpcAftermathService;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.common.request.CommonRequest;
import com.yeejoin.amos.spc.dao.entity.SpcAftermath;
import com.yeejoin.amos.spc.exception.YeeException;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "/api/spcAftermath")
@Api(tags = "可能造成的后果")
public class SpcAftermathController extends BaseController {
    private static final Logger log = Logger.getLogger(SpcAftermathController.class);
    @Autowired
    private ISpcAftermathService iSpcAftermathService;
    

    @ApiOperation(httpMethod = "POST", value = "分页查询", notes = "分页查询")
    @RequestMapping(value = "/pagelist", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse qrySpcAftermathClassifyPage(@ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests,
                                                      @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        List<DaoCriteria> criterias = buildDaoCriterias(queryRequests);
//        ReginParams reginParams = getSelectedOrgInfo(); //公共数据，不用按照org_code过滤，20191105
//        DaoCriteria compDaoCriteria = new DaoCriteria();
//        compDaoCriteria.setPropertyName("orgCode");
//        compDaoCriteria.setOperator(QueryOperatorEnum.EQUAL.getName());
//        compDaoCriteria.setValue(getLoginOrgCode(reginParams));
//        criterias.add(compDaoCriteria);
        Page<SpcAftermath> list = iSpcAftermathService.queryEntryByCondition(criterias, commonPageable);
        return CommonResponseUtil.success(list);
    }

    /**
     * 新增及编辑
     */
    @ApiOperation(httpMethod = "POST", value = "新增及编辑", notes = "新增及编辑")
    @RequestMapping(value = "/save", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse SpcAftermathEdit(@ApiParam(value = "后果实体类", required = true) @RequestBody SpcAftermath entry) {
        try {
        	
        	List<SpcAftermath> spcAftermaths = iSpcAftermathService.queryAftermathByName(entry.getName());
        	if(null != entry.getId()) {//为编辑时过滤自己
        		spcAftermaths = spcAftermaths.stream().filter(e -> e.getId() != entry.getId()).collect(Collectors.toList());
        	}
        	if(spcAftermaths != null && spcAftermaths.size()>0) {
        		return CommonResponseUtil.failure("后果已存在！");
        	}
            ReginParams reginParams = getSelectedOrgInfo();
            entry.setCreatorId(getUserId());
            entry.setOrgCode(getLoginOrgCode(reginParams));
            entry.setUpdateDate(new Date());
            iSpcAftermathService.addEntry(entry);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("后果操作失败");
        }
    }

    /**
     * 删除（支持批量）
     */
    @ApiOperation(httpMethod = "POST", value = "删除", notes = "删除")
    @RequestMapping(value = "/delEntryByIds", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse deletePlanById(
            @ApiParam(value = "后果ID数组", required = true) @RequestBody String[] param) {
        try {
            iSpcAftermathService.delEntryById(param);
            return CommonResponseUtil.success();
        } catch (YeeException e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure(e.getMessage());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("删除失败");
        }
    }

}
