package com.yeejoin.amos.spc.business.controller;

import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.service.intfc.ISpcEvaluateNormService;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.common.request.CommonRequest;
import com.yeejoin.amos.spc.dao.entity.SpcEvaluateNorm;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Administrator
 */
@RestController
@RequestMapping(value = "/api/spcEvaluateNorm")
@Api(tags = "风险评判标准")
public class SpcEvaluateNormController extends BaseController {


    @Autowired
    private ISpcEvaluateNormService spcEvaluateNormService;

    /**
     * 新增风险评判标准
     */
    @ApiOperation(httpMethod = "POST", value = "新增风险评价准则", notes = "新增风险评价准则")
    @PostMapping(value = "/save", produces = "application/json;charset=UTF-8")
    public CommonResponse saveSpcEvaluateModel(@RequestBody SpcEvaluateNorm evaluateNorm) {
    	List<SpcEvaluateNorm> evaluateNorms = spcEvaluateNormService.queryEvaluateNormByNameAndEvaluateId(evaluateNorm.getName(),evaluateNorm.getEvaluateModelId());
    	if(null != evaluateNorm.getId()) {//为编辑时过滤自己
    		evaluateNorms = evaluateNorms.stream().filter(e -> e.getId() != evaluateNorm.getId()).collect(Collectors.toList());
    	}
    	if(evaluateNorms != null && evaluateNorms.size()>0) {
    		return CommonResponseUtil.failure("风险准则已存在！");
    	}
        evaluateNorm.setCreatorId(getUserId());
        evaluateNorm.setUpdateDate(new Date());
        spcEvaluateNormService.save(evaluateNorm);
        return CommonResponseUtil.success(evaluateNorm);
    }

    /**
     * 删除风险等级
     */
    @ApiOperation(httpMethod = "DELETE", value = "删除风险等级", notes = "删除风险等级")
    @DeleteMapping(value = "/delete/{ids}", produces = "application/json;charset=UTF-8")
    public CommonResponse delete(@PathVariable String ids) {
        String[] idArray = ids.split(",");
        spcEvaluateNormService.delete(idArray);
        return CommonResponseUtil.success();
    }


    /**
     * 风险等级列表页面查询
     */
    @ApiOperation(httpMethod = "POST", value = "风险等级列表页面查询", notes = "风险等级列表页面查询")
    @PostMapping(value = "/list", produces = "application/json;charset=UTF-8")
    public CommonResponse queryPage(
            @ApiParam(value = "查询条件")
            @RequestBody(required = false) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        List<DaoCriteria> criterias = buildDaoCriterias(queryRequests);
        Page<SpcEvaluateNorm> list = spcEvaluateNormService.list(criterias, commonPageable);
        return CommonResponseUtil.success(list);
    }
}
