package com.yeejoin.amos.spc.business.controller;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.param.ReginParams;
import com.yeejoin.amos.spc.business.service.intfc.IHazardSourceClassifyService;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.common.request.CommonRequest;
import com.yeejoin.amos.spc.dao.entity.SpcHazardSourceClassify;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "/api/spcHazardSourceClassify")
@Api(tags = "危险源分类")
public class SpcHazardSourceClassifyController extends BaseController {
    private static final Logger log = Logger.getLogger(SpcHazardSourceClassifyController.class);
    @Autowired
    private IHazardSourceClassifyService iHazardSourceClassifyService;

    @ApiOperation(httpMethod = "POST", value = "危险源分类查询", notes = "危险源分类查询")
    @RequestMapping(value = "/pagelist", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse qryHazardSourceClassifyPage(@ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests,
                                                      @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        List<DaoCriteria> criterias = buildDaoCriterias(queryRequests);
//        ReginParams reginParams = getSelectedOrgInfo();//公共数据，不用按照org_code过滤，20191105
//        DaoCriteria compDaoCriteria = new DaoCriteria();
//        compDaoCriteria.setPropertyName("orgCode");
//        compDaoCriteria.setOperator(QueryOperatorEnum.EQUAL.getName());
//        compDaoCriteria.setValue(getLoginOrgCode(reginParams));
//        criterias.add(compDaoCriteria);
        Page<SpcHazardSourceClassify> list = iHazardSourceClassifyService.queryEntryByCondition(criterias, commonPageable);
        return CommonResponseUtil.success(list);
    }

    /**
     * 危险源分类新增及编辑
     */
    @ApiOperation(httpMethod = "POST", value = "危险源分类新增及编辑", notes = "危险源分类新增及编辑")
    @RequestMapping(value = "/save", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse SpcHazardSourceClassifyEdit(@ApiParam(value = "危险源分类", required = true) @RequestBody SpcHazardSourceClassify entry) {
        try {
        	List<SpcHazardSourceClassify> findByName = iHazardSourceClassifyService.findByName(entry.getName());
        	if(null != entry.getId()) {//为编辑时过滤自己
        		findByName = findByName.stream().filter(e -> e.getId() != entry.getId()).collect(Collectors.toList());
        	}
        	if(findByName != null && findByName.size()>0) {
        		return CommonResponseUtil.failure("该危险源分类已存在！");
        	}
            ReginParams reginParams = getSelectedOrgInfo();
            entry.setCreatorId(getUserId());
            entry.setOrgCode(getLoginOrgCode(reginParams));
            entry.setUpdateDate(new Date());
            iHazardSourceClassifyService.addEntry(entry);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("危险源分类新增失败");
        }
    }

    /**
     * 危险源分类删除（支持批量）
     */
    @ApiOperation(httpMethod = "POST", value = "删除危险源分类", notes = "删除危险源分类")
    @RequestMapping(value = "/delEntryByIds", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse deletePlanById(
            @ApiParam(value = "危险源分类ID", required = true) @RequestBody String[] param) {
        try {
            iHazardSourceClassifyService.delEntryById(param);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("删除危险源分类失败");
        }
    }
}
