package com.yeejoin.amos.spc.business.dao.mapper;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.yeejoin.amos.bank.TopographyNode;
import com.yeejoin.amos.bank.entity.DeviceRecord;
import com.yeejoin.amos.bank.entity.EquipmentQualityVo;
import com.yeejoin.amos.bank.entity.EquipmentVo;
import com.yeejoin.amos.spc.bo.EquipmentBo;
import com.yeejoin.amos.spc.business.param.PageParam;

public interface EquipmentMapper extends BaseMapper {

    List<Map<String, Object>> listOptionByMap(Map<String, Object> map);

    List<EquipmentBo> listByMap(PageParam pageParam);

    Long countByMap(PageParam pageParam);

    
    void insertEquipment(EquipmentVo vo);
    
    //void updateEquipment(EquipmentVo vo);
     
    //void updateEquipmentAttrs(EquipmentQualityVo vo);
    void insertEquipmentAttrs( EquipmentQualityVo vo);
    
    
    /**
     * 更新指标关联表中指标的状态
     * @param status
     * @param id
     */
    void updateEquipmentPointStatus(@Param("state")int state,@Param("equipmentsPointId") Long equipmentsPointId);
    
    /**
     * 根据设备Id和指标名称查询指标详情
     * @param equipmentId
     * @param remark
     * @return
     */
    EquipmentQualityVo queryEquipmentPoint(@Param("equipmentId") Long equipmentId,@Param("remark") String remark);
    
    /**
     * 判断关联关系表中该指标是否存在
     * @param equipmentsPointId
     * @return
     */
    List<Long> judgeEquipmentExists(@Param("equipmentsPointId") Long equipmentsPointId);
    
    /**
     * 判断关联关系表中该指标是否存在
     * @param equipmentsPointId
     * @return
     */
	 List<DeviceRecord> querySelfDevice(
	            @Param("start")long start,
	            @Param("length")int length,
	            @Param("fname") String fname
	            );

	 Long querySelfDeviceCount(
	            @Param("fname") String fname);
	 
	 TopographyNode queryNodeBySourceId( @Param("sourceId")String sourceId);
	 
	 void updateNodeState(TopographyNode node);
	 
	 
	 void updateNodeDetail(@Param("nodeid")String nodeid,@Param("nodeDetail")String nodeDetail);
	 
	 void deleteOneHourNormal();
}
