package com.yeejoin.amos.spc.business.dao.mapper;

import com.yeejoin.amos.spc.bo.RiskFactorBo;
import com.yeejoin.amos.spc.business.param.CommonPageInfoParam;
import com.yeejoin.amos.spc.business.param.PageParam;

import java.util.HashMap;
import java.util.List;

public interface PlanMapper extends BaseMapper {

    RiskFactorBo getByInstanceIdOfEquipment(Long evaluateId);

	RiskFactorBo getByInstanceIdOfTaskwork(Long evaluateId);

    RiskFactorBo findById(Long id);

    Integer update(RiskFactorBo riskFactorBo);
    
    /**
     * 危险因素查询，分页查询统计用
     * @param param
     * @return
     */
 	long countPageData(CommonPageInfoParam param);
     
 	/**
 	 * 危险因素分页查询
 	 * @param param
 	 * @return
 	 */
 	List<HashMap<String, Object>> queryRiskFactorPage(CommonPageInfoParam param);
 	
 	/**
 	 * 根据风险因素查询管控措施详情
 	 * @param riskFactorId
 	 * @return
 	 */
 	List<HashMap<String, Object>> queryControlMeasureDetailByRiskFactorId(Long riskFactorId);

 	List<RiskFactorBo> listByMap(PageParam pageParam);

	Long countByMap(PageParam pageParam);

	List<RiskFactorBo> listEquipmentRiskFactorByEquipmentIds(List<Long> equipmentIds);
}
