package com.yeejoin.amos.spc.business.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.assertj.core.util.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.spc.bo.EvaluateModelBo;
import com.yeejoin.amos.spc.business.dao.repository.ISpcEvaluateModelDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcMajorHazardInstallationDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcRiskFactorDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcRiskLevelDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcTaskworkContentDao;
import com.yeejoin.amos.spc.business.remote.RemoteSecurityService;
import com.yeejoin.amos.spc.business.service.intfc.ISpcRiskLevelService;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.util.query.BaseQuerySpecification;
import com.yeejoin.amos.spc.dao.entity.SpcEvaluateModel;
import com.yeejoin.amos.spc.dao.entity.SpcRiskLevel;
import com.yeejoin.amos.spc.exception.YeeException;

@Service("spcRiskLevelService")
public class SpcRiskLevelServiceImpl implements ISpcRiskLevelService {

    @Autowired
    private ISpcRiskLevelDao iSpcRiskLevelDao;
    
    @Autowired
    private ISpcRiskFactorDao iSpcRiskFactorDao;
    
    @Autowired
    private ISpcTaskworkContentDao iSpcTaskworkContentDao;
    
    @Autowired
    private ISpcMajorHazardInstallationDao iSpcMajorHazardInstallationDao;

    @Autowired
    private RemoteSecurityService remoteSecurityService;
    
    @Autowired
    private ISpcEvaluateModelDao iSpcEvaluateModelDao;

    @Override
    public SpcRiskLevel save(SpcRiskLevel riskLevel) {
        return iSpcRiskLevelDao.save(riskLevel);
    }

    @Override
    public void delete(String[] ids) {
    	List<String> removedIds = new ArrayList<>();
    	List<String> riskLevelNames = new ArrayList<>();
        for (String id : ids) {
        	int count1 = iSpcRiskFactorDao.countByRiskLevelId(id);
        	int count2 = iSpcTaskworkContentDao.countByRiskLevelId(id);
        	int count3 = iSpcMajorHazardInstallationDao.countByRiskLevelId(id);
        	if (count1 + count2 + count3 > 0) {
        		removedIds.add(id);
        		riskLevelNames.add(iSpcRiskLevelDao.findById(Long.valueOf(id)).get().getLevel());
        	}
        }
        List<String> newArr = new ArrayList<>(Arrays.asList(ids));
        newArr.removeAll(removedIds);
    	if (newArr.size() > 0) {
            for (String id : newArr) {
                Long riskLevelId = Long.valueOf(id);
                if (iSpcRiskLevelDao.existsById(riskLevelId)) {
                    iSpcRiskLevelDao.deleteById(riskLevelId);
                }
            }
        }
    	if (removedIds.size() > 0) {
    		throw new YeeException("风险【" + Joiner.on(",").join(riskLevelNames) + "】等级在使用中，删除失败！");
    	}
    }

    @Override
    public Page<SpcRiskLevel> list(List<DaoCriteria> criterias, CommonPageable commonPageable) {
        BaseQuerySpecification<SpcRiskLevel> spec = new BaseQuerySpecification<>(criterias);
        Sort sort = new Sort(Sort.Direction.DESC,"id");
        commonPageable.setSort(sort);
        Page<SpcRiskLevel> page = iSpcRiskLevelDao.findAll(spec, commonPageable);
        List<SpcRiskLevel> list = page.getContent();
        if (!CollectionUtils.isEmpty(list)) {
            List<String> userIds = Lists.transform(list, SpcRiskLevel::getCreatorId);
            Set<String> userIdSets = Sets.newHashSet(userIds);
            userIdSets.remove(null);
            List<AgencyUserModel> AgencyUserModels = remoteSecurityService.listUserByUserIds(Joiner.on(",").join(userIdSets));
            Map<String, AgencyUserModel> AgencyUserModelMap = Maps.uniqueIndex(AgencyUserModels, AgencyUserModel::getUserId);
            list.forEach(e -> {
                AgencyUserModel AgencyUserModel = AgencyUserModelMap.get(e.getCreatorId());
                if (AgencyUserModel != null) {
                    e.setCreateUserName(AgencyUserModel.getRealName());
                }
            });
        }
        return page;
    }

	@Override
	public List<SpcRiskLevel> findAll() {
		// TODO Auto-generated method stub
		return iSpcRiskLevelDao.findAll();
	}

	@Override
	public List<SpcRiskLevel> findByEvaluateModelId(Long evModelId) {
		return iSpcRiskLevelDao.findByEvaluateModelId(evModelId);
	}

	@Override
	public List<EvaluateModelBo> getRiskLevelTree() {
		List<EvaluateModelBo> modelLevelTree = new ArrayList<>();
		List<SpcEvaluateModel> evaModelList = iSpcEvaluateModelDao.findAll();
		evaModelList.forEach(model -> {
			EvaluateModelBo evaModelBo = new EvaluateModelBo();
			evaModelBo.setKey(model.getId());
			evaModelBo.setValue(model.getId());
			evaModelBo.setLabel(model.getName());
			evaModelBo.setType("model");
			List<SpcRiskLevel> riskLevelList = iSpcRiskLevelDao.findByEvaluateModelId(model.getId());
			List<EvaluateModelBo> levelBoList = new ArrayList<>();
			riskLevelList.forEach(level -> {
				EvaluateModelBo levelBo = new EvaluateModelBo();
				levelBo.setKey(level.getId());
				levelBo.setValue(level.getId());
				levelBo.setLabel(level.getLevel());
				levelBo.setType("level");
				levelBoList.add(levelBo);
			});
			evaModelBo.setChildren(levelBoList);
			modelLevelTree.add(evaModelBo);
		});
		return modelLevelTree;
	}

	@Override
	public List<SpcRiskLevel> queryModelByLevelAndEvaluateId(String level, Long evaluateModelId) {
		return iSpcRiskLevelDao.findByLevelAndEvaluateModelId(level,evaluateModelId);
	}
}
