package com.yeejoin.amos.spc.business.service.impl;


import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.spc.business.remote.RemoteSecurityService;
import com.yeejoin.amos.spc.business.service.intfc.ISpcSecurityService;

@Service("spcSecurityService")
public class SpcSecurityServiceImpl implements ISpcSecurityService {

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Override
    public List<DepartmentModel> listDepartmentTree(String companyId) {
        return remoteSecurityService.getDepartmentTreeByCompanyId(companyId);
    }

    @Override
    public Object listUserByCompanyId(String companyId) {
        return remoteSecurityService.getUserAndDepartmentTreeByCompanyId(companyId);
    }

	@Override
	public Object queryByOrgcode(String orgcode) {
		// TODO Auto-generated method stub
		 return remoteSecurityService.queryByOrgcode(orgcode);
	}

	@Override
	public List<DepartmentModel> querySubAgencyTree(String departmentid) {
		// TODO Auto-generated method stub
		return remoteSecurityService.querySubAgencyTree(departmentid);
	}


}
