package com.yeejoin.amos.spc.business.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.assertj.core.util.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.spc.business.dao.mapper.View3DMapper;
import com.yeejoin.amos.spc.business.dao.repository.ISpcEquipmentDao;
import com.yeejoin.amos.spc.business.remote.RemoteSecurityService;
import com.yeejoin.amos.spc.business.service.intfc.IView3DService;
import com.yeejoin.amos.spc.common.enums.LatentDangerStateEnum;
import com.yeejoin.amos.spc.core.common.response.DangerDetailsResponse;
import com.yeejoin.amos.spc.core.common.response.Node3DVoResponse;
import com.yeejoin.amos.spc.core.common.response.RiskSourceDetailsResponse;
import com.yeejoin.amos.spc.core.util.StringUtil;
import com.yeejoin.amos.spc.dao.entity.SpcEquipment;


@Service("view3DService")
public class View3DServiceImpl implements IView3DService {

    @Autowired
    private View3DMapper view3DMapper;

    @Autowired
    private ISpcEquipmentDao iSpcEquipmentDao;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Override
    public List<Node3DVoResponse> findViewDataByType(String type,String orgCode) {
        // TODO Auto-generated method stub
        List<Node3DVoResponse> dataList = view3DMapper.findViewDataByType(type,orgCode);
        return dataList;
    }

    @Override
    public RiskSourceDetailsResponse getRiskSourceDetailsById(Long id) {
        // TODO Auto-generated method stub
        return view3DMapper.queryRiskSourceDetailsById(id);
    }

    @Override
    public SpcEquipment getEquipDetailsById(Long id) {
        // TODO Auto-generated method stub
        SpcEquipment spcEquipment = iSpcEquipmentDao.findById(id).get();
        Set<String> userIdSets = Sets.newHashSet();
        Set<String> deptIdSets = Sets.newHashSet();
        userIdSets.add(spcEquipment.getCompanyLeaderUserId());
        userIdSets.add(spcEquipment.getDeptLeaderUserId());
        userIdSets.add(spcEquipment.getClassLeaderUserId());
        userIdSets.add(spcEquipment.getShopLeaderUserId());
        deptIdSets.add(spcEquipment.getRegionId());
        deptIdSets.add(spcEquipment.getDepartmentId());
        userIdSets.remove(null);
        userIdSets.remove("");
        deptIdSets.remove(null);
        deptIdSets.remove("");
        List<DepartmentModel> DepartmentModels = remoteSecurityService.listDepartmentByDeptIds(Joiner.on(",").join(deptIdSets));
        List<AgencyUserModel> AgencyUserModels = remoteSecurityService.listUserByUserIds(Joiner.on(",").join(userIdSets));
        Map<String, AgencyUserModel> AgencyUserModelMap = Maps.uniqueIndex(AgencyUserModels, AgencyUserModel::getUserId);
        Map<Long, DepartmentModel> DepartmentModelMap = Maps.uniqueIndex(DepartmentModels, DepartmentModel::getSequenceNbr);
        AgencyUserModel companyAgencyUserModel = AgencyUserModelMap.get(spcEquipment.getCompanyLeaderUserId());
        if (companyAgencyUserModel != null) {
            spcEquipment.setCompanyLeaderUserRealName(companyAgencyUserModel.getRealName());
        }
        AgencyUserModel deptAgencyUserModel = AgencyUserModelMap.get(spcEquipment.getDeptLeaderUserId());
        if (deptAgencyUserModel != null) {
            spcEquipment.setDeptLeaderUserRealName(deptAgencyUserModel.getRealName());
        }
        AgencyUserModel shopAgencyUserModel = AgencyUserModelMap.get(spcEquipment.getShopLeaderUserId());
        if (shopAgencyUserModel != null) {
            spcEquipment.setShopLeaderUserRealName(shopAgencyUserModel.getRealName());
        }
        AgencyUserModel classAgencyUserModel = AgencyUserModelMap.get(spcEquipment.getClassLeaderUserId());
        if (classAgencyUserModel != null) {
            spcEquipment.setClassLeaderUserRealName(classAgencyUserModel.getRealName());
        }
        DepartmentModel regionDepartment = DepartmentModelMap.get(spcEquipment.getRegionId());
        if (regionDepartment != null) {
            spcEquipment.setRegionDepartmentName(regionDepartment.getDepartmentName());
        }
        DepartmentModel department = DepartmentModelMap.get(spcEquipment.getDepartmentId());
        if (department != null) {
            spcEquipment.setDepartmentName(department.getDepartmentName());
        }
//        DepartmentModel leaderDepartment = DepartmentModelMap.get(spcEquipment.getLeaderDepartmentId());
//        if (leaderDepartment != null) {
//            spcEquipment.setLeaderDepartmentName(leaderDepartment.getDepartmentName());
//        }
//         spcEquipment.setWorkshopSection(EquipmentTypeEnum.getEnumName(spcEquipment.getWorkshopSection()));
        return spcEquipment;
    }

    @Override
    public RiskSourceDetailsResponse getDangerDetailsById(Long id) {
        RiskSourceDetailsResponse riskSourceDetailsResponse = view3DMapper.queryDangerDetailsById(id);
        if (StringUtil.isNotEmpty(riskSourceDetailsResponse)) {
            List<DangerDetailsResponse> dangerDetails = riskSourceDetailsResponse.getDangerDetails();
            if (dangerDetails.size() > 0) {
                Set<String> userIdSets = Sets.newHashSet();
                dangerDetails.forEach(action -> {
                    userIdSets.add(action.getExecutor());
                });
                userIdSets.remove(null);
                userIdSets.remove("");
                List<AgencyUserModel> AgencyUserModels = remoteSecurityService.listUserByUserIds(Joiner.on(",").join(userIdSets));
                Map<String, AgencyUserModel> AgencyUserModelMap = Maps.uniqueIndex(AgencyUserModels, AgencyUserModel::getUserId);
                dangerDetails.forEach(action -> {
                    AgencyUserModel AgencyUserModel = AgencyUserModelMap.get(action.getExecutor());
                    if (AgencyUserModel != null) {
                        action.setExecutor(AgencyUserModel.getRealName());
                    }
                    action.setStatus(LatentDangerStateEnum.getEnumName(Integer.valueOf(action.getStatus())));
                    action.setLevel(action.getLevel() == "1" ? "一般隐患" : "重大隐患");
                });
            }
        }
        return riskSourceDetailsResponse;
    }

	@Override
	public HashMap<String, Object> getPointDetailsById(Long id) {
		return view3DMapper.queryPointDetailsById(id);
	}


}
