package com.yeejoin.amos.spc.business.service.intfc;

import java.util.HashMap;
import java.util.List;

import com.yeejoin.amos.spc.dao.entity.RRiskSource;
import org.springframework.data.domain.Page;

import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.spc.bo.RiskSourceBo;
import com.yeejoin.amos.spc.business.param.CommonPageInfoParam;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.common.request.RiskFactorAddRequest;
import com.yeejoin.amos.spc.dao.entity.SpcRiskSource;

public interface ISpcRiskSourceService {

    public SpcRiskSource save(SpcRiskSource spcRiskSource, String token);

    /**
     * 根据组织编码获取危险源
     *
     * @param orgCode
     * @return
     */
    public List<SpcRiskSource> list(String orgCode);

    List<RiskSourceBo> listAll(String orgCode);
    
    public void delete(String[] ids);

    SpcRiskSource getRiskSourceDetailsById(Long id);
    
    RiskSourceBo getRiskSourceBoDetailById(Long id);

    /**
     * 改危险源是否存在该危险因素名称
     *
     * @param riskSourceId
     * @param name
     * @return
     */
    Boolean isExistFactorByName(Long riskSourceId, String name);

    public void saveRiskFactor(RiskFactorAddRequest riskFactors);

    public void deleteRiskFactor(String[] ids);

//    void saveBatchRiskFactor(RiskFactorParam riskFactorParam, Long userId);
//
//    void deleteBatchRiskFactor(List<Long> ids);

    /**
     * 分页查询风险源的风险因素
     */
    Page<HashMap<String, Object>> queryRiskFactorByPage(CommonPageInfoParam param);

    HashMap<String, Object> queryControlObjectDetailById(Long riskFactorId);

    /**
     * 风险因素管控措施详情
     *
     * @param riskFactorId
     * @return
     */
    List<HashMap<String, Object>> queryControlMeasureDetailByRiskFactorId(Long riskFactorId,Long evaluateId);

    Page<HashMap<String, Object>> listRegion(CommonPageInfoParam commonPageInfoParam);
    
    /**
     * 分页查询设备设施
     *
     * @param criterias
     * @param commonPageable
     * @return
     */
    Page<SpcRiskSource> querySpcRiskSourceByPage(List<DaoCriteria> criterias, CommonPageable commonPageable);

	public List<SpcRiskSource> getRiskSourceByType(String type);


    public String  processFireEqumtData(String equipId) throws Exception;

    /**
     * 根据楼层查询风险数据
     * @param floor 楼层
     * @return 风险数据
     */
    public List<RRiskSource> getRiskSourceByFloor(String floor, String orgCode);

    /**
     * 更新风险点三维坐标
     * @param spcRiskSource
     */
    public void updatePosition3dById(SpcRiskSource spcRiskSource);
}
