package com.yeejoin.amos.spc.core.util;


import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * Created by magintursh on 2018/1/8.
 */
public class DateUtils {


    /**
     * 获取  当前年、半年、季度、月、日、小时 开始结束时间
     */
    private static final SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat longHourSdf = new SimpleDateFormat("yyyy-MM-dd HH");
    private static final SimpleDateFormat longSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");


    /**
     * 获得本周的第一天，周一
     *
     * @return
     */
    public static Date getCurrentWeekDayStartTime(Date date) throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int weekday = c.get(Calendar.DAY_OF_WEEK) - 2;
        c.add(Calendar.DATE, -weekday);
        c.setTime(longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00"));
        return c.getTime();
    }

    /**
     * 获得本周的最后一天，周日
     *
     * @return
     */
    public static Date getCurrentWeekDayEndTime(Date date) throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int weekday = c.get(Calendar.DAY_OF_WEEK);
        c.add(Calendar.DATE, 8 - weekday);
        c.setTime(longSdf.parse(shortSdf.format(c.getTime()) + " 23:59:59"));
        return c.getTime();
    }

    /**
     * 获得本天的开始时间，即2012-01-01 00:00:00
     *
     * @return
     */
    public static Date getCurrentDayStartTime(Date date) throws Exception {
        date = shortSdf.parse(shortSdf.format(date) + " 00:00:00");
        return date;
    }

    /**
     * 获得本天的结束时间，即2012-01-01 23:59:59
     *
     * @return
     */
    public static Date getCurrentDayEndTime(Date date) throws Exception {
        date = longSdf.parse(shortSdf.format(date) + " 23:59:59");
        return date;
    }

    /**
     * 获得本小时的开始时间，即2012-01-01 23:00:00
     *
     * @return
     */
    public static Date getCurrentHourStartTime(Date date) throws Exception {
        date = longHourSdf.parse(longHourSdf.format(date) + "00:00");
        return date;
    }

    /**
     * 获得本小时的结束时间，即2012-01-01 23:59:59
     *
     * @return
     */
    public static Date getCurrentHourEndTime(Date date) throws Exception {
        date = longSdf.parse(longHourSdf.format(date) + ":59:59");
        return date;
    }

    /**
     * 获得本月的开始时间，即2012-01-01 00:00:00
     *
     * @return
     */
    public static Date getCurrentMonthStartTime(Date date) throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Date now = null;
        c.set(Calendar.DATE, 1);
        now = shortSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00");
        return now;
    }

    /**
     * 当前月的结束时间，即2012-01-31 23:59:59
     *
     * @return
     */
    public static Date getCurrentMonthEndTime(Date date) throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Date now = null;
        c.set(Calendar.DATE, 1);
        c.add(Calendar.MONTH, 1);
        c.add(Calendar.DATE, -1);
        now = longSdf.parse(shortSdf.format(c.getTime()) + " 23:59:59");
        return now;
    }

    /**
     * 当前年的开始时间，即2012-01-01 00:00:00
     *
     * @return
     */
    public static Date getCurrentYearStartTime(Date date) throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Date now = null;
        c.set(Calendar.MONTH, 0);
        c.set(Calendar.DATE, 1);
        now = shortSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00");
        return now;
    }

    /**
     * 当前年的结束时间，即2012-12-31 23:59:59
     *
     * @return
     */
    public static Date getCurrentYearEndTime(Date date) throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Date now = null;
        c.set(Calendar.MONTH, 11);
        c.set(Calendar.DATE, 31);
        now = longSdf.parse(shortSdf.format(c.getTime()) + " 23:59:59");
        return now;
    }

    /**
     * 当前季度的开始时间，即2012-01-1 00:00:00
     *
     * @return
     */
    public static Date getCurrentQuarterStartTime(Date date) throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(Calendar.MONTH) + 1;
        Date now = null;
        if (currentMonth >= 1 && currentMonth <= 3)
            c.set(Calendar.MONTH, 0);
        else if (currentMonth >= 4 && currentMonth <= 6)
            c.set(Calendar.MONTH, 3);
        else if (currentMonth >= 7 && currentMonth <= 9)
            c.set(Calendar.MONTH, 4);
        else if (currentMonth >= 10 && currentMonth <= 12)
            c.set(Calendar.MONTH, 9);
        c.set(Calendar.DATE, 1);
        now = longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00");
        return now;
    }

    /**
     * 当前季度的结束时间，即2012-03-31 23:59:59
     *
     * @return
     */
    public static Date getCurrentQuarterEndTime(Date date) throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(Calendar.MONTH) + 1;
        Date now = null;
        if (currentMonth >= 1 && currentMonth <= 3) {
            c.set(Calendar.MONTH, 2);
            c.set(Calendar.DATE, 31);
        } else if (currentMonth >= 4 && currentMonth <= 6) {
            c.set(Calendar.MONTH, 5);
            c.set(Calendar.DATE, 30);
        } else if (currentMonth >= 7 && currentMonth <= 9) {
            c.set(Calendar.MONTH, 8);
            c.set(Calendar.DATE, 30);
        } else if (currentMonth >= 10 && currentMonth <= 12) {
            c.set(Calendar.MONTH, 11);
            c.set(Calendar.DATE, 31);
        }
        now = longSdf.parse(shortSdf.format(c.getTime()) + " 23:59:59");
        return now;
    }

    /**
     * 获取前/后半年的开始时间
     *
     * @return
     */
    public static Date getHalfYearStartTime(Date date) throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(Calendar.MONTH) + 1;
        Date now = null;
        if (currentMonth >= 1 && currentMonth <= 6) {
            c.set(Calendar.MONTH, 0);
        } else if (currentMonth >= 7 && currentMonth <= 12) {
            c.set(Calendar.MONTH, 6);
        }
        c.set(Calendar.DATE, 1);
        now = longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00");
        return now;

    }

    /**
     * 获取前/后半年的结束时间
     *
     * @return
     */
    public static Date getHalfYearEndTime(Date date) throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(Calendar.MONTH) + 1;
        Date now = null;
        if (currentMonth >= 1 && currentMonth <= 6) {
            c.set(Calendar.MONTH, 5);
            c.set(Calendar.DATE, 30);
        } else if (currentMonth >= 7 && currentMonth <= 12) {
            c.set(Calendar.MONTH, 11);
            c.set(Calendar.DATE, 31);
        }
        now = longSdf.parse(shortSdf.format(c.getTime()) + " 23:59:59");
        return now;
    }

    public static String getWeekOfYearForString(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(Calendar.YEAR);
        int weekOfYear = calendar.get(Calendar.WEEK_OF_YEAR);
        return year + "" + weekOfYear;
    }


}
