package com.yeejoin.amos.bank.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 火探 告警点类型
 *
 */
public enum FireDetectionAlarmType {
	产生("未处理(产生)", "1","异常"),
	清除("历史(清除)", "2","正常"),
	删除("删除(逻辑删除)", "3","正常");
	
    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;
    /**
     * 状态
     */
    private String status;

    FireDetectionAlarmType(String name, String code, String status) {
        this.name = name;
        this.code = code;
        this.setStatus(status);
    }

    public static FireDetectionAlarmType getEnum(String code) {
        FireDetectionAlarmType instance = null;
        for (FireDetectionAlarmType type : FireDetectionAlarmType.values()) {
            if (type.getCode().equals(code)) {
                instance = type;
                break;
            }
        }

        return instance;
    }

    public static String getEnumStatus(String code) {
        String status = "";
        for (FireDetectionAlarmType type : FireDetectionAlarmType.values()) {
            if (type.getCode().equals(code)) {
            	status = type.getStatus();
                break;
            }
        }

        return status;
    }

    public static List<Map<String, String>> getEnumList() {
        List<Map<String, String>> list = new ArrayList<>();
        for (FireDetectionAlarmType e : FireDetectionAlarmType.values()) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("code", e.getCode());
            map.put("name", e.getName());
            list.add(map);
        }
        return list;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

	/**
	 * @return the status
	 */
	public String getStatus() {
		return status;
	}

	/**
	 * @param status the status to set
	 */
	public void setStatus(String status) {
		this.status = status;
	}
}
