package com.yeejoin.amos.bank.common.enums;


/**
 * PMTS 设备类型
 */
public enum PMTSTypeEnum {
    
	XAPMTSA01("XAPMTSA01", "XAPMTSAP1"),
	XAPMTSA02("XAPMTSA02", "XAPMTSAP1"),
	XAPMTSB01("XAPMTSB01", "XAPMTSAP2"),
	XAPMTSB02("XAPMTSB02", "XAPMTSAP2");
    /**
     * 名称
     */
    private String name;
    /**
     * 类型
     */
    private String type;

    PMTSTypeEnum(String name, String type) {
        this.name = name;
        this.type = type;
    }
    
    public static String getEnumType(String name) {
        for (PMTSTypeEnum e : PMTSTypeEnum.values()) {
            if(e.getName().equals(name)) {
            	return e.getType();
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
