package com.yeejoin.amos.bank.common.enums;

/**
 * topo 类型
 */
public enum TopoNodeTypeEnum {
    
	网络拓扑图("网络拓扑图", 1),
	PAMS("PAMS", 2),
	动环监控("动环监控", 3),
	设备监控("设备监控", 4),
	自建系统("自建系统", 5),
    金融城域网("金融城域网", 6),
    虚拟云平台监控("虚拟云平台监控", 7);
    /**
     * 名称
     */
    private String name;
    /**
     * 类型
     */
    private int type;

    TopoNodeTypeEnum(String name, int type) {
        this.name = name;
        this.type = type;
    }
    
    public static int getEnumType(String name) {
        for (TopoNodeTypeEnum e : TopoNodeTypeEnum.values()) {
            if(e.getName().equals(name)) {
            	return e.getType();
            }
        }
        return 0;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }
}
