package com.yeejoin.amos.bank.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

@Entity
@Table(name = "b_device_record")
@org.hibernate.annotations.Table(appliesTo = "b_device_record", comment = "设备连接情况记录表")
public class DeviceRecord implements Serializable {


	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = -800598236816673288L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id", nullable = true)
	private Long id;

	@Column(name = "name", columnDefinition = "varchar(1024) COMMENT '设备名称'")
	private String name;

	@Column(name = "device_id", columnDefinition = "varchar(1024) COMMENT '设备id'")
	private Long deviceId;


	@Column(name = "metric_data", columnDefinition = "varchar(255) COMMENT '指标数据'")
	private String metricData;

	@Column(name = "device_status", columnDefinition = "int(10) COMMENT '设备状态 0-合格  1-不合格'")
	private int deviceStatus;

	
	@Column(name = "update_date", columnDefinition="datetime COMMENT '修改时间'")
	private Date updateDate;


	public Long getId() {
		return id;
	}


	public void setId(Long id) {
		this.id = id;
	}


	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}


	public Long getDeviceId() {
		return deviceId;
	}


	public void setDeviceId(Long deviceId) {
		this.deviceId = deviceId;
	}


	public String getMetricData() {
		return metricData;
	}


	public void setMetricData(String metricData) {
		this.metricData = metricData;
	}


	public int getDeviceStatus() {
		return deviceStatus;
	}


	public void setDeviceStatus(int deviceStatus) {
		this.deviceStatus = deviceStatus;
	}


	public Date getUpdateDate() {
		return updateDate;
	}


	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
	
}
