package com.yeejoin.amos.bank.entity;

import org.springframework.data.domain.Page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 分页返回模板对象
 * @author zhangzhihui
 *
 * @param <T>
 */
public class PageModel<T> {
	/**
	 * 总记录数
	 */
	private Integer total;
	/**
	 * 当前页数
	 */
	private Integer currPage;
	/**
	 * 总页数
	 */
	private Integer totalPage;
	/**
	 * 每页记录数
	 */
	private Integer pageSize;
	/**
	 * 数据
	 */
	private List<T> dataList;

	public PageModel(){}

	public PageModel(Integer total, Integer currPage, Integer pageSize, List<T> dataList) {
		super();
		this.total = total;
		this.currPage = currPage;
		this.pageSize = pageSize;
		this.dataList = dataList;

		totalPage = (total - 1)/pageSize + 1;
	}

	public PageModel(Integer currPage, Integer pageSize, List<T> dataAll) {
		super();
		this.total = dataAll.size();
		this.currPage = currPage;
		this.pageSize = pageSize;

		List<T> subList = null;
		Integer start = pageSize*(currPage-1);
		if(start >= dataAll.size()) {
			subList = new ArrayList<>();
		}else if(start+pageSize >= dataAll.size()) {
			subList = dataAll.subList(start,dataAll.size());
		}else {
			subList = dataAll.subList(start, start+pageSize);
		}
		this.dataList = subList;

		totalPage = (total - 1)/pageSize + 1;
	}

	/**
	 * jpa查询得到的分页转换为PageModel
	 * @param page
	 */
	public PageModel(Page<T> page){
		long t = page.getTotalElements();
		this.total = ((Long)t).intValue();
		this.currPage = page.getNumber()+1;
		this.pageSize = page.getSize();
		this.dataList = page.getContent();
		this.totalPage = page.getTotalPages();
	}

	public Integer getPageSize() {
		return pageSize;
	}

	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

	public Integer getTotal() {
		return total;
	}

	public void setTotal(Integer total) {
		this.total = total;
	}

	public Integer getCurrPage() {
		return currPage;
	}

	public void setCurrPage(Integer currPage) {
		this.currPage = currPage;
	}

	public Integer getTotalPage() {
		return totalPage;
	}

	public void setTotalPage(Integer totalPage) {
		this.totalPage = totalPage;
	}

	public List<T> getDataList() {
		return dataList;
	}

	public void setDataList(List<T> dataList) {
		this.dataList = dataList;
	}

	/**
	 * 本方法用于方便前端处理分页参数
	 * @return
	 */
	public Map<String, Object> getParameterMap(){
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("current", currPage);
		map.put("total", total);
		map.put("pageSize", pageSize);
		return map;
	}
}
