package com.yeejoin.amos.bank.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @Author: xinglei
 * @Description: 通讯录
 * @Date: 2019/12/9 14:41
 */
@Entity
@Table( name= "b_situation_phonebook")
@org.hibernate.annotations.Table(appliesTo = "b_situation_phonebook",comment="通讯录")
public class PhoneBook extends BaseEntity{

    private static final long serialVersionUID = -7259346431765966576L;
    /**
     * 名称
     */
    @Column(name ="name", nullable=true,unique = true, columnDefinition="varchar(255) COMMENT '名称'")
    private String name;
    /**
     * 岗位
     */
    @Column(name ="post", nullable=true,unique = true, columnDefinition="varchar(255) COMMENT '岗位'")
    private String post;
    /**
     * 等级
     */
    @Column(name ="level", nullable=true, columnDefinition="varchar(255) COMMENT '等级 1 | 一线人员 2| 二线人员 3|代班领导'")
    private String level;
    /**
     * 电话号码
     */
    @Column(name ="phone", nullable=true,unique = true, columnDefinition="varchar(255) COMMENT '电话号码'")
    private String phone;
    
    /**
     *部门
     */
    @Column(name ="dept_id", nullable=true, columnDefinition="varchar(255) COMMENT '部门'")
    private String deptId;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPost() {
        return post;
    }

    public void setPost(String post) {
        this.post = post;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
}
