package com.yeejoin.amos.spc.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 计划类型
 * @author maoying
 *
 */
public enum PlanTypeEnum {
	day("日","1"),
	week("周","2"),
	month("月","3"),
	year("年","4");
	
	/**
	 * 名称，描述
	 */
	private String name;
	/**
	 * 编码
	 */
	private String code;
	
	private PlanTypeEnum(String name,String code){
		this.name = name;
		this.code = code;
	}
	
	public static PlanTypeEnum getEnum(String code) {
		PlanTypeEnum instance = null;
		for(PlanTypeEnum type: PlanTypeEnum.values()) {
			if (type.getCode().equals(code)) {
				instance = type;
				break;
			}
		}
		
		return instance;
	}
	
	public static String getEnumName(String code) {
		String name = "";
		for(PlanTypeEnum type: PlanTypeEnum.values()) {
			if (type.getCode().equals(code)) {
				name = type.getName();
				break;
			}
		}
		
		return name;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> list = new ArrayList<>();
		for(PlanTypeEnum e : PlanTypeEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("code", e.getCode());
			map.put("name", e.getName());
			list.add(map);
		}
		return list;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
}
