package com.yeejoin.amos.spc.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 风险管控内容状态
 * @author maoying
 *
 */
public enum RiskFactorsCmStatusEnum {
	
	Control("受控","1"),
	outOfControl("失控","2"),
	generalDanger("一般","3"),
	majorDanger("重要","4");
	/**
	 * 名称，描述
	 */
	private String name;
	/**
	 * 编码
	 */
	private String code;
	
	private RiskFactorsCmStatusEnum(String name,String code){
		this.name = name;
		this.code = code;
	}
	
	public static RiskFactorsCmStatusEnum getEnum(String code) {
		RiskFactorsCmStatusEnum instance = null;
		for(RiskFactorsCmStatusEnum type: RiskFactorsCmStatusEnum.values()) {
			if (type.getCode().equals(code)) {
				instance = type;
				break;
			}
		}
		
		return instance;
	}
	
	public static String getEnumName(String code) {
		String name = "";
		for(RiskFactorsCmStatusEnum type: RiskFactorsCmStatusEnum.values()) {
			if (type.getCode().equals(code)) {
				name = type.getName();
				break;
			}
		}
		
		return name;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> list = new ArrayList<>();
		for(RiskFactorsCmStatusEnum e : RiskFactorsCmStatusEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("code", e.getCode());
			map.put("name", e.getName());
			list.add(map);
		}
		return list;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
}
