package com.yeejoin.amos.spc.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 危险因素状态
 * @author Administrator
 *
 */
public enum RiskFactorsStatusEnum {
	notStarted("未开始","0"),
	execution("执行中","1"),
	hang("挂起","2"),
	finish("执行完成","3"),
	cancel("撤销","4");
	
	/**
	 * 名称，描述
	 */
	private String name;
	/**
	 * 编码
	 */
	private String code;
	
	private RiskFactorsStatusEnum(String name,String code){
		this.name = name;
		this.code = code;
	}
	
	public static RiskFactorsStatusEnum getEnum(String code) {
		RiskFactorsStatusEnum riskFactorsTypeEnum = null;
		for(RiskFactorsStatusEnum type: RiskFactorsStatusEnum.values()) {
			if (type.getCode().equals(code)) {
				riskFactorsTypeEnum = type;
				break;
			}
		}
		
		return riskFactorsTypeEnum;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> list = new ArrayList<>();
		for(RiskFactorsStatusEnum e : RiskFactorsStatusEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("code", e.getCode());
			map.put("name", e.getName());
			list.add(map);
		}
		return list;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
}
