package com.yeejoin.amos.spc.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 危险因素类型
 * @author Administrator
 *
 */
public enum RiskFactorsTypeEnum {
	equipment("设备设施危险因素","1"),
	taskwork("作业活动危险因素","2");
	
	/**
	 * 名称，描述
	 */
	private String name;
	/**
	 * 编码
	 */
	private String code;
	
	private RiskFactorsTypeEnum(String name,String code){
		this.name = name;
		this.code = code;
	}
	
	public static RiskFactorsTypeEnum getEnum(String code) {
		RiskFactorsTypeEnum riskFactorsTypeEnum = null;
		for(RiskFactorsTypeEnum type: RiskFactorsTypeEnum.values()) {
			if (type.getCode().equals(code)) {
				riskFactorsTypeEnum = type;
				break;
			}
		}
		
		return riskFactorsTypeEnum;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> list = new ArrayList<>();
		for(RiskFactorsTypeEnum e : RiskFactorsTypeEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("code", e.getCode());
			map.put("name", e.getName());
			list.add(map);
		}
		return list;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
}
