package com.yeejoin.amos.spc.common.enums;

public enum TaskworkStateEnum {
    未启动("未启动", 0, "D_0"),
    待作业活动申请("待作业活动申请", 1, "D_1"),
    待班组审核("待班组审核", 2, "D_2"),
    待车间部门审核("待车间部门审核", 3, "D_3"),
    待公司审核("待公司审核", 4, "D_4"),
    待执行("待执行", 5, "D_5"),
    待确认验收("待确认验收", 6, "D_6"),
    完成("完成", 7, "");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private Integer code;

    private String actionFlag;

    TaskworkStateEnum(String name, Integer code, String actionFlag) {
        this.name = name;
        this.code = code;
        this.actionFlag = actionFlag;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getActionFlag() {
        return actionFlag;
    }

    public void setActionFlag(String actionFlag) {
        this.actionFlag = actionFlag;
    }

    public static TaskworkStateEnum getByCode(Integer code) {
        for (TaskworkStateEnum l : TaskworkStateEnum.values()) {
            if (code.equals(l.getCode())) {
                return l;
            }
        }
        return null;
    }

    public static TaskworkStateEnum getByActionFlag(String actionFlag) {
        for (TaskworkStateEnum l : TaskworkStateEnum.values()) {
            if (actionFlag.equals(l.getActionFlag())) {
                return l;
            }
        }
        return TaskworkStateEnum.完成;
    }
}
