package com.yeejoin.amos.spc.dao.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import org.springframework.data.annotation.LastModifiedDate;


/**
 * The persistent class for the spc_aftermath database table.
 * 
 */
@Entity
@Table(name="spc_aftermath")
@NamedQuery(name="SpcAftermath.findAll", query="SELECT s FROM SpcAftermath s")
public class SpcAftermath extends BasicEntity {
	private static final long serialVersionUID = 1L;

	@Column(name="creator_id")
	private String creatorId;

	private String describe;

	private String name;

	@Column(name="org_code")
	private String orgCode;

	@LastModifiedDate
	@Column(name="update_date")
	private Date updateDate;

	public SpcAftermath() {
	}

	public String getCreatorId() {
		return this.creatorId;
	}

	public void setCreatorId(String creatorId) {
		this.creatorId = creatorId;
	}

	@Column(name="`describe`")
	public String getDescribe() {
		return this.describe;
	}

	public void setDescribe(String describe) {
		this.describe = describe;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public Date getUpdateDate() {
		return this.updateDate;
	}

	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

}