package com.yeejoin.amos.spc.dao.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

/*
 * 重大危险源
 */
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name="spc_major_hazard_installation")
@NamedQuery(name="SpcMajorHazardInstallation.findAll", query="SELECT s FROM SpcMajorHazardInstallation s")
public class SpcMajorHazardInstallation extends BasicEntity {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 名称
	 */
	private String name;
	
	/**
	 * 编号
	 */
	private String code;
	
	/*
	 * 风险区域ID
	 */
	@Column(name = "risk_source_id")
	private Long riskSourceId;
	
	/**
	 * 危险区域名称
	 */
	private String riskSourceName;
	
	/**
	 * 等级ID
	 */
	@Column(name = "risk_level")
	private Long riskLevel;
	
	/**
	 * 风险等级名称
	 */
	private String riskLevelName;
	
	/**
	 * 辨识人ID
	 */
	@Column(name = "identification_user_id")
	private String identificationUserId;
	
	/**
	 * 辨识人名称
	 */
	private String identificationUserName;
	
	/**
	 * 辨识方法ID
	 */
	@Column(name = "identification_method_id")
	private String identificationMethodId;
	
	/**
	 * 辨识方法名称
	 */
	private String identificationMethodName;
	
	/**
	 * 三维坐标：-177.0789,0,21.6566(x,y,z)
	 */
	private String position3d;
	
	/**
	 * 信息楼层
	 */
	private int floor3d;
	
	/**
	 * 室内室外：1 为室内，0为室外
	 */
	private Boolean isIndoor;
	
	@Column(name = "org_code")
    private String orgCode;
	
	@LastModifiedDate
	@Column(name="update_date")
	private Date updateDate;
	
	/**
	 * 创建人
	 */
	@Column(name="creator_id")
	private String creatorId = "";
	
	private String markType;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public Long getRiskSourceId() {
		return riskSourceId;
	}

	public void setRiskSourceId(Long riskSourceId) {
		this.riskSourceId = riskSourceId;
	}

	@Transient
	public String getRiskSourceName() {
		return riskSourceName;
	}

	public void setRiskSourceName(String riskSourceName) {
		this.riskSourceName = riskSourceName;
	}

	public Long getRiskLevel() {
		return riskLevel;
	}

	public void setRiskLevel(Long riskLevel) {
		this.riskLevel = riskLevel;
	}

	@Transient
	public String getRiskLevelName() {
		return riskLevelName;
	}

	public void setRiskLevelName(String riskLevelName) {
		this.riskLevelName = riskLevelName;
	}

	public String getIdentificationUserId() {
		return identificationUserId;
	}

	public void setIdentificationUserId(String identificationUserId) {
		this.identificationUserId = identificationUserId;
	}

	public String getIdentificationMethodId() {
		return identificationMethodId;
	}

	public void setIdentificationMethodId(String identificationMethodId) {
		this.identificationMethodId = identificationMethodId;
	}

	public String getPosition3d() {
		return position3d;
	}

	public void setPosition3d(String position3d) {
		this.position3d = position3d;
	}

	public int getFloor3d() {
		return floor3d;
	}

	public void setFloor3d(int floor3d) {
		this.floor3d = floor3d;
	}

	public Boolean getIsIndoor() {
		return isIndoor;
	}

	public void setIsIndoor(Boolean isIndoor) {
		this.isIndoor = isIndoor;
	}

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public Date getUpdateDate() {
		return updateDate;
	}

	@LastModifiedDate
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

	public String getCreatorId() {
		return creatorId;
	}

	public void setCreatorId(String creatorId) {
		this.creatorId = creatorId;
	}

	@Transient
	public String getIdentificationUserName() {
		return identificationUserName;
	}

	public void setIdentificationUserName(String identificationUserName) {
		this.identificationUserName = identificationUserName;
	}

	@Transient
	public String getIdentificationMethodName() {
		return identificationMethodName;
	}

	public void setIdentificationMethodName(String identificationMethodName) {
		this.identificationMethodName = identificationMethodName;
	}

	@Transient
	public String getMarkType() {
		return markType;
	}

	public void setMarkType(String markType) {
		this.markType = markType;
	}
}
