package com.yeejoin.amos.spc.dao.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;


/**
 * The persistent class for the spc_risk_factors_cm database table.
 * 
 */
@Entity
@Table(name="spc_risk_factors_cm")
@NamedQuery(name="SpcRiskFactorsCm.findAll", query="SELECT s FROM SpcRiskFactorsCm s")
public class SpcRiskFactorsCm extends BasicEntity {
	private static final long serialVersionUID = 1L;

	@Column(name="control_measures_id")
	private Long controlMeasuresId;

	@Column(name="evaluate_id")
	private Long evaluateId;

	/**
	 * 管控措施状态
	 */
	private String status;
	


	@Column(name="measures_content_id")
	private Long measuresContentId;

	@Column(name="risk_factors_id")
	private Long riskFactorsId;

	@Column(name = "update_date")
	private Date updateDate;
	
	public SpcRiskFactorsCm() {
	}

	public Long getControlMeasuresId() {
		return this.controlMeasuresId;
	}

	public void setControlMeasuresId(Long controlMeasuresId) {
		this.controlMeasuresId = controlMeasuresId;
	}

	public Long getEvaluateId() {
		return this.evaluateId;
	}

	public void setEvaluateId(Long evaluateId) {
		this.evaluateId = evaluateId;
	}

	public Long getMeasuresContentId() {
		return this.measuresContentId;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public void setMeasuresContentId(Long measuresContentId) {
		this.measuresContentId = measuresContentId;
	}

	public Long getRiskFactorsId() {
		return this.riskFactorsId;
	}

	public void setRiskFactorsId(Long riskFactorsId) {
		this.riskFactorsId = riskFactorsId;
	}

	public Date getUpdateDate() {
		return updateDate;
	}

	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

}