package com.yeejoin.amos.spc.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import java.util.Date;


/**
 * The persistent class for the spc_risk_judgment_task database table.
 */
@Entity
@Table(name = "spc_risk_judgment_task")
@NamedQuery(name = "SpcRiskJudgmentTask.findAll", query = "SELECT s FROM SpcRiskJudgmentTask s")
public class SpcRiskJudgmentTask extends BasicEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 业务唯一标识
     */
    @Column(name = "taskDefinitionKey")
    private String taskDefinitionKey;

    /**
     * 业务唯一标识
     */
    @Column(name = "current_flow_task_id")
    private String currentFlowTaskId;

    /**
     * 是否删除（0：否；1：是）
     */
    private Integer deleted;

    /**
     * 部门编号
     */
    @Column(name = "department_id")
    private String departmentId;

    /**
     * 工作流实例编号
     */
    @Column(name = "flow_instance_id")
    private String flowInstanceId;

    /**
     * 可执行用户（多个逗号隔开）
     */
    @Column(name = "flow_user_ids")
    private String flowUserIds;

    /**
     * 提交时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "task_commit_date")
    private Date taskCommitDate;

    @Temporal(TemporalType.DATE)
    @Column(name = "task_date")
    private Date taskDate;

    /**
     * 风险研判名称
     */
    @Column(name = "task_name")
    private String taskName;

    /**
     * 状态（0：未开始；1：进行中；2：已超时；3：已提交）
     */
    @Column(name = "task_status")
    private Integer taskStatus;

    /**
     * 组织机构编号
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 记录修改时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_date")
    private Date updateDate;

    public SpcRiskJudgmentTask() {
    }

    public String getTaskDefinitionKey() {
        return taskDefinitionKey;
    }

    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    public String getCurrentFlowTaskId() {
        return currentFlowTaskId;
    }

    public void setCurrentFlowTaskId(String currentFlowTaskId) {
        this.currentFlowTaskId = currentFlowTaskId;
    }

    public Integer getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public String getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(String departmentId) {
        this.departmentId = departmentId;
    }

    public String getFlowInstanceId() {
        return this.flowInstanceId;
    }

    public void setFlowInstanceId(String flowInstanceId) {
        this.flowInstanceId = flowInstanceId;
    }

    public String getFlowUserIds() {
        return this.flowUserIds;
    }

    public void setFlowUserIds(String flowUserIds) {
        this.flowUserIds = flowUserIds;
    }

    public Date getTaskCommitDate() {
        return this.taskCommitDate;
    }

    public void setTaskCommitDate(Date taskCommitDate) {
        this.taskCommitDate = taskCommitDate;
    }

    public Date getTaskDate() {
        return this.taskDate;
    }

    public void setTaskDate(Date taskDate) {
        this.taskDate = taskDate;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public Integer getTaskStatus() {
        return this.taskStatus;
    }

    public void setTaskStatus(Integer taskStatus) {
        this.taskStatus = taskStatus;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
}