package com.yeejoin.amos.spc.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedQuery;
import javax.persistence.Table;


/**
 * The persistent class for the spc_taskwork_content database table.
 * 
 */
@Entity
@Table(name="spc_taskwork_content")
@NamedQuery(name="SpcTaskworkContent.findAll", query="SELECT s FROM SpcTaskworkContent s")
public class SpcTaskworkContent extends BasicEntity  {
	private static final long serialVersionUID = 1L;


	/**
	 * 内容
	 */
	private String content;

	/**
	 * 作业活动步骤执行状态：0-未执行；1-已执行
	 */
	@Column(name="execute_state")
	private Integer executeState;

	/**
	 * 照片url
	 */
	@Lob
	private String img;

	/**
	 * 备注
	 */
	private String remark;

	/**
	 * 风险等级id
	 */
	@Column(name="risk_level_id")
	private Long riskLevelId;

	/**
	 * 序号
	 */
	@Column(name="serial_num")
	private int serialNum;
	
	/**
	 * 违章状态1-无违章；2-一般违章；3-严重违章
	 */
	@Column(name="violate_state")
	private Long violateState = 1L;

	public Long getViolateState() {
		return violateState;
	}


	public void setViolateState(Long violateState) {
		this.violateState = violateState;
	}

	/**
	 * 作业活动id
	 */
	@Column(name="taskwork_id")
	private Long taskworkId;

	public SpcTaskworkContent() {
	}


	public String getContent() {
		return this.content;
	}

	public void setContent(String content) {
		this.content = content;
	}
	
	public Integer getExecuteState() {
		return this.executeState;
	}

	public void setExecuteState(Integer executeState) {
		this.executeState = executeState;
	}

	public String getImg() {
		return this.img;
	}

	public void setImg(String img) {
		this.img = img;
	}

	public String getRemark() {
		return this.remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public Long getRiskLevelId() {
		return this.riskLevelId;
	}

	public void setRiskLevelId(Long riskLevelId) {
		this.riskLevelId = riskLevelId;
	}

	public int getSerialNum() {
		return this.serialNum;
	}

	public void setSerialNum(int serialNum) {
		this.serialNum = serialNum;
	}

	public Long getTaskworkId() {
		return this.taskworkId;
	}

	public void setTaskworkId(Long taskworkId) {
		this.taskworkId = taskworkId;
	}

}