package com.yeejoin.amos.bank.config;

import java.util.List;
import java.util.Map;

import com.yeejoin.amos.spc.core.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.component.emq.EmqxListener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yeejoin.amos.bank.common.enums.DevicePointEnum;
import com.yeejoin.amos.bank.entity.EquipmentQualityVo;
import com.yeejoin.amos.bank.remote.client.RiskModelRemoteClient;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.spc.business.dao.mapper.EquipmentMapper;

@Component
public class BlueprintListener extends EmqxListener implements InitializingBean {

    private final Logger logger = LogManager.getLogger(BlueprintListener.class);

    private static ObjectMapper mapper = new ObjectMapper();

    @Autowired
    private EmqKeeper emqKeeper;

    private static TaskExecutor taskExecutor;

    @Autowired
    EquipmentMapper equipmentMapper;

    @Autowired
    RiskModelRemoteClient riskModelRemoteClient;


    /**
     * 监听主题
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        emqKeeper.subscript(CommTopic.BLUEPRINT.getTopic(), 2, this);
    }

    /**
     * 接收主题下的消息
     */
    @Override
    public void processMessage(String s, MqttMessage mqttMessage) throws Exception {

        blueprintMsgtransfer(mqttMessage);
    }


    /**
     * 消息处理
     *
     * @param mqttMessage
     */
    private void blueprintMsgtransfer(MqttMessage mqttMessage) {

        try {
            String jsonStr = new String(mqttMessage.getPayload());
            logger.error(">>>>>>>>>>>>>>>>>jsonStr",jsonStr);
            JSONObject parseObject = JSON.parseObject(jsonStr);
            Long eqpId = parseObject.getLong("eqpId");
            JSONArray jsonArray = parseObject.getJSONArray("metricDatas");
            if (ObjectUtils.isEmpty(jsonArray)) {
                return;
            }
            jsonArray.forEach(e -> {
                JSONObject object = (JSONObject) e;
                String string = object.getString("metricJson");
                if (!StringUtil.isNotEmpty(string)) {
                    return;
                }
                logger.error(">>>>>>>>>>>>>>>>>string",string);
                JSONObject metricJson = JSONObject.parseObject(string);
                for (Map.Entry entry : metricJson.entrySet()) {
                    // 指标名
                    String remark = entry.getKey().toString();
                    String statusName = entry.getValue().toString();
                    if (!remark.equals("describe")) {
                        EquipmentQualityVo queryEquipmentPoint = equipmentMapper.queryEquipmentPoint(eqpId, remark);
                        Long equipmentsPointId = queryEquipmentPoint.getId();
                        List<Long> riskFactorId = equipmentMapper.judgeEquipmentExists(equipmentsPointId);

                        if ((remark.equals("currentState") || "异常".equals(statusName) || "正常".equals(statusName)) && !ObjectUtils.isEmpty(queryEquipmentPoint) && riskFactorId.size() > 0) {
                            logger.error(">>>>>>>>>>>>>>>>>remark",remark);
                            logger.error(">>>>>>>>>>>>>>>>>statusName",statusName);
                            // 指标的值 0正常 1告警
                            Integer value = DevicePointEnum.getValue(statusName);
                            equipmentMapper.updateEquipmentPointStatus(value, queryEquipmentPoint.getId());
                            try {
                                for (int j = 0; j < riskFactorId.size(); j++) {
                                    riskModelRemoteClient.updateEquipmentAlarmData(riskFactorId.get(j));
                                }
                            } catch (InnerInvokException e1) {
                                logger.error("update rpn fail " + e1.getMessage());
                            }
                        }
                    }
                }

//                for (Map.Entry entry : metricJson.entrySet()) {
//                    // 指标名
//                    String remark = entry.getKey().toString();
//                    String statusName = entry.getValue().toString();
//                    if (!remark.equals("describe")) {
//                        EquipmentQualityVo queryEquipmentPoint = equipmentMapper.queryEquipmentPoint(eqpId, remark);
//                        Long equipmentsPointId = queryEquipmentPoint.getId();
//                        Integer value = 0;
//                        if (remark.equals("currentState")){
//                            value = DevicePointEnum.getValue(remark);
//                        } else {
//                            value = DevicePointEnum.getValue(statusName);
//                        }
//                        List<Long> riskFactorId = equipmentMapper.judgeEquipmentExists(equipmentsPointId);
//                        if (null != riskFactorId && riskFactorId.size() > 0) {
//                            // 指标的值 0正常 1告警
//                            equipmentMapper.updateEquipmentPointStatus(value, queryEquipmentPoint.getId());
//                            try {
//                                //riskModelRemoteClient.updateEquipmentAlarmData(Long.valueOf(25));
//                                for (int j = 0; j < riskFactorId.size(); j++) {
//                                    riskModelRemoteClient.updateEquipmentAlarmData(riskFactorId.get(j));
//                                }
//
//                            } catch (InnerInvokException e1) {
//                                logger.error("update rpn fail " + e1.getMessage());
//                            }
//                        }
//                    }
//                }
            });

        } catch (Exception e) {
            logger.error("消息流转报错.");
            logger.error(e.getMessage(), e);
            e.printStackTrace();
        }
    }
}
