package com.yeejoin.amos.bank.controller;

import com.yeejoin.amos.bank.dao.entity.AlarmPoint;
import com.yeejoin.amos.bank.param.DepartmentBo;
import com.yeejoin.amos.bank.service.IAlarmPointService;
import com.yeejoin.amos.bank.service.IAlarmService;
import com.yeejoin.amos.bank.service.IAutoInspectionService;
import com.yeejoin.amos.bank.webSocket.MonitorAlarmWebSocketClient;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.controller.BaseController;
import com.yeejoin.amos.spc.business.param.ReginParams;
import com.yeejoin.amos.spc.business.remote.RemoteSecurityService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@RequestMapping(value = "/bank/alarm")
@Api(value = "/bank/alarm", tags = {"告警数据API"})
public class AlarmPointController extends BaseController {

    private final Logger log = LoggerFactory.getLogger(AlarmPointController.class);

    @Autowired
    private IAlarmPointService alarmPointService;

    @Autowired
    private IAutoInspectionService autoInspectionService;
    @Autowired
    private IAlarmService iAlarmService;
    @Autowired
    private RemoteSecurityService remoteSecurityService;

    /**
     * 获取告警数据
     *
     * @return 告警数据
     */
    @GetMapping(value = "/list", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "告警数据", notes = "告警数据")
    public CommonResponse getAlarms() {
        Sort sort = new Sort(Sort.Direction.DESC, "updateDate");
        List<AlarmPoint> alarms = alarmPointService.findAll(sort);
        return CommonResponseUtil.success(alarms);
    }


    @GetMapping(value = "/tigger", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "告警触发", notes = "告警触发")
    public CommonResponse alarmTigger(@ApiParam(value = "xmlData", required = false) String xmlData) {
    	 String token = getToken();
         alarmPointService.alarmTigger(xmlData, token);
         return CommonResponseUtil.success();
    }

    @GetMapping(value = "/aislelist", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "通道告警数据", notes = "通道告警数据")
    public CommonResponse aisleSummary(@ApiParam(value = "city", required = false) String city) {
        return CommonResponseUtil.success(autoInspectionService.aisleSummary(city, null));
    }

    @GetMapping(value = "/topoAislelist", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "Topo通道告警数据", notes = "Topo通道告警数据")
    public CommonResponse topoAislelist() {
        return CommonResponseUtil.success(autoInspectionService.topoAislelist());
    }

    @GetMapping(value = "/bankInfoList", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "查询银行经纬度列表", notes = "查询银行经纬度列表")
    public CommonResponse bankInfoList() {
        return CommonResponseUtil.success(autoInspectionService.bankInfoList());
    }
    
      @SuppressWarnings("unused")
      @ApiOperation(value = "巡检点统计", notes = "首页统计")
      @PostMapping(value = "/mobile/getcountxd")
      public CommonResponse getcountxd(@RequestBody Map maps) {
    	
          //String code=maps.get("code").toString();
          //获取当前登录人公司orgcode
          
          ReginParams reginParams =getSelectedOrgInfo();
          
          String code=reginParams.getCompany().getOrgCode();
        //  List<HashMap<String, Object>> listxd=  iAlarmService.getcountxd(code);
          List<HashMap<String, Object>> listyc=  iAlarmService.getcountyc( code);
         // List<HashMap<String, Object>> list2= iAlarmService.getcountnum(code);
          
          List<HashMap<String, Object>> lista  =new ArrayList<>();
          
//          for (int i = 0; i < listxd.size(); i++) {
//        	  HashMap<String, Object> map =new  HashMap<>();
//        	  for (int j = 0; j < listyc.size(); j++) {
//        		  if(listxd.get(i).get("code").toString().equals(listyc.get(j).get("code").toString())){
//        			  String z="0";
//        			  String y="0";
//        			  if(listxd.get(i).get("num")!=null){
//        				  z=listxd.get(i).get("num").toString();
//        			  }
//				      if(listyc.get(j).get("num")!=null){
//				    	  y=listyc.get(j).get("num").toString();     				  
//						}
//						        			  
//        			  map.put("value", z+"/"+y);
//                 	  map.put("name", listxd.get(i).get("name"));
//                      map.put("level",listxd.get(i).get("code"));
//        			  
//        		  }
//        		  
//        	  }
//        	  lista.add(map);
//        	 
//		   }
          int num=0;
          for (int i = 0; i < listyc.size(); i++) {
        	  HashMap<String, Object> map =new  HashMap<>();
        	  String ynum="0";
        	  if(listyc.get(i).get("num")!=null){
        		  num=num+Integer.valueOf(listyc.get(i).get("num").toString()); 
        		  ynum=listyc.get(i).get("num").toString();
        	  }       	 		  
        	  map.put("value",ynum);
         	  map.put("name", listyc.get(i).get("name"));
              map.put("level",listyc.get(i).get("code"));
          	  
        	  lista.add(map);
        	 
		   }
          
          
          Map<String, Object> map =new HashMap<>();
         
       	   map.put("total",num);
         
           map.put("data", lista);
          return CommonResponseUtil.success(map);
      }

    
    //巡检点统计
    
      @SuppressWarnings("unused")
      @ApiOperation(value = "巡检点统计", notes = "首页统计")
      @GetMapping(value = "/mobile/getxuncount")
      public CommonResponse getxuncount() {
           ReginParams reginParams =getSelectedOrgInfo();         
          String code=reginParams.getCompany().getOrgCode();
         List<HashMap<String, Object>> listyc=  iAlarmService.getxuncount( code);
         
         xun xu= new xun();
         int count=0;
         if(listyc!=null&&listyc.size()>0){
        	 for (int i = 0; i < listyc.size(); i++) {
            	 
        		 switch(listyc.get(i).get("status")+""){
        		 case "0":
        			int nu= Integer.valueOf(listyc.get(i).get("num").toString()) ;
        			 count= count+nu;     			
        			 xu.setNotIncluded(nu);
        		     break;
        		 case "1":
        			 int nu1= Integer.valueOf(listyc.get(i).get("num").toString()) ;
        			 count= count+nu1;     			
        			 xu.setNormal(nu1);
        		     break;
        		 case "2": 
        			 int nu2= Integer.valueOf(listyc.get(i).get("num").toString()) ;
        			 count= count+nu2;     			
        			 xu.setAbnormal(nu2);
        		     break;       		
        		 default:
        			 int nu3= Integer.valueOf(listyc.get(i).get("num").toString()) ;
        			 count= count+nu3;     			
        			 xu.setMissedDetection(nu3);
        		     break;
        		 }       	 
			}        	 
        	 xu.setCountnum(count);
         }              
          return CommonResponseUtil.success(xu);
      }
    
        class xun{
    	  
        	int  notIncluded;//未纳入巡检;
        	int  normal;//正常;
        	int  abnormal;//异常;
        	int  missedDetection;//漏检;        	 
        	int  countnum;//总数;  
			public int getNotIncluded() {
				return notIncluded;
			}
			public void setNotIncluded(int notIncluded) {
				this.notIncluded = notIncluded;
			}
			public int getNormal() {
				return normal;
			}
			public void setNormal(int normal) {
				this.normal = normal;
			}
			public int getAbnormal() {
				return abnormal;
			}
			public void setAbnormal(int abnormal) {
				this.abnormal = abnormal;
			}
			public int getMissedDetection() {
				return missedDetection;
			}
			public void setMissedDetection(int missedDetection) {
				this.missedDetection = missedDetection;
			}
			public int getCountnum() {
				return countnum;
			}
			public void setCountnum(int countnum) {
				this.countnum = countnum;
			}
    	  
      }
      
      
     
    
    
    @ApiOperation(value = "获取当前用户所属公司的所有部门", notes = "获取当前用户所属公司的所有部门")
    @RequestMapping(value = "/queryDept", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryCurrentCompanyDept() {


    	ReginParams reginParams =getSelectedOrgInfo();
        Long dep = reginParams.getCompany().getSequenceNbr();
    
        List<DepartmentModel> departmentModels = remoteSecurityService.listDepartmentsByCompanyId(dep);
        List<DepartmentBo> departmentBos = ModelToBo(departmentModels);
        return CommonResponseUtil.success(departmentBos);
    }
    
    
    
    
    
    /**
     * 类型转换  DepartmentModel => DepartmentBo
     * @param departmentModels
     * @return
     */
    private List<DepartmentBo> ModelToBo(List<DepartmentModel> departmentModels){
        List<DepartmentBo> departmentBos = new ArrayList<>();
        departmentModels.forEach(
          x -> {
              DepartmentBo departmentBo = new DepartmentBo();
              departmentBo.setSequenceNbr(x.getSequenceNbr()+"@"+x.getOrgCode());
              departmentBo.setCompanySeq(x.getCompanySeq().toString());
              departmentBo.setDepartmentDesc(x.getDepartmentDesc());
              departmentBo.setDepartmentName(x.getDepartmentName());
              departmentBo.setDeptOrgCode(x.getOrgCode());
              departmentBo.setLevel(x.getLevel());
              departmentBo.setOrgCode(x.getOrgCode());
              departmentBo.setParentId(x.getParentId().toString());
              if (!ObjectUtils.isEmpty(x.getChildren())) {
                  Object collect = x.getChildren().stream().collect(Collectors.toList());
                  List<LinkedHashMap> children = (List<LinkedHashMap>) collect;
                  //departmentBo.setChildren(children);
                  departmentBos.addAll(ModelToBo2(children));
              }
              departmentBos.add(departmentBo);
          }
        );
        return departmentBos;
    }
    
    
    private List<DepartmentBo> ModelToBo2(List<LinkedHashMap> departmentModels){
        List<DepartmentBo> departmentBos = new ArrayList<>();
        departmentModels.forEach(
          x -> {
              DepartmentBo departmentBo = new DepartmentBo();
              departmentBo.setSequenceNbr(x.get("sequenceNbr")+"@"+x.get("orgCode"));
              departmentBo.setCompanySeq(x.get("companySeq").toString());
              departmentBo.setDepartmentDesc(x.get("departmentDesc")+"");
              departmentBo.setDepartmentName(x.get("departmentName")+"");
              departmentBo.setDeptOrgCode(x.get("orgCode")+"");
              departmentBo.setLevel(x.get("level")+"");
              departmentBo.setOrgCode(x.get("orgCode")+"");
              departmentBo.setParentId(x.get("parentId")+"");
              
              if (x.get("children")!=null) {
            	  List<LinkedHashMap> collect = (List<LinkedHashMap>) x.get("children");
            	  departmentBos.addAll( ModelToBo2(collect));         	     
              }
              departmentBos.add(departmentBo);
          }
        );
        return departmentBos;
    }
    
    
    
    
    
}
