package com.yeejoin.amos.bank.controller;

import com.yeejoin.amos.bank.entity.PatrolRoute;
import com.yeejoin.amos.bank.service.PatrolRouteService;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author: xinglei
 * @Description: 巡检路线Controller
 * @Date: 2019/12/10 16:52
 */
@RestController
@RequestMapping(value = "/api/patrol")
@Api(value = "/api/patrol", tags = {"巡检路线API"})
public class PatrolRouteController {

    private static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(PatrolRouteController.class);

    @Autowired
    private PatrolRouteService patrolRouteService;

    /**
     * 添加巡检路线信息
     *
     * @return
     */
    @ApiOperation(httpMethod = "POST", value = "添加巡检路线", notes = "添加巡检路线")
    @PostMapping(value = "/addRoute", produces = "application/json;charset=UTF-8")
    public CommonResponse addRoute(@ApiParam(value = "添加巡检路线", required = true) @RequestBody(required = true) PatrolRoute patrolRoute) {
        boolean flag = patrolRouteService.add(patrolRoute);
        if (flag) {
            return CommonResponseUtil.success("保存成功");
        } else {
            return CommonResponseUtil.failure("保存失败");
        }
    }
}
