package com.yeejoin.amos.bank.controller;

import com.yeejoin.amos.bank.entity.PhoneBook;
import com.yeejoin.amos.bank.service.PhoneBookService;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Author: xinglei
 * @Description: TODO()
 * @Date: 2019/12/9 14:36
 */
@RestController
@RequestMapping(value = "/bank/phonebook")
@Api(value = "/bank/phonebook", tags = {"通讯录API"})
public class PhoneBookController {

    @Autowired
    private PhoneBookService phoneBookService;

    @GetMapping(value = "/list", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "获取通讯录列表", notes = "获取通讯录列表")
    public CommonResponse getPhoneBook() {
        List<PhoneBook> phoneBookList = phoneBookService.findAll();
        return CommonResponseUtil.success(phoneBookList);
    }
}
