package com.yeejoin.amos.bank.dao.repository;

import java.util.List;

import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import com.yeejoin.amos.bank.TopographyEvent;
import com.yeejoin.amos.bank.dao.entity.AlarmPoint;
import com.yeejoin.amos.op.core.jpa.IBaseRepository;

@Repository("iAlarmPointDao")
public interface IAlarmPointRepository extends IBaseRepository<AlarmPoint, String> {

	@Query(value="select * from p_alarm_point where point_type =?1 and point_id =?2 ",nativeQuery=true )
	public List<AlarmPoint> selectPointTypeAndPointId(String type, Long pointId);

	public List<AlarmPoint> deleteByIdIn(List<Long> idList);

	@Query(value="select * from p_alarm_point where point_type IN ('4','5') and point_id =?1 and content = ?2 ",nativeQuery=true )
	public List<AlarmPoint> selectPointTypeAndPointId(String pointId,String content);
}
