package com.yeejoin.amos.bank.dao.repository;

import java.util.List;

import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import com.yeejoin.amos.bank.TopographyLine;
import com.yeejoin.amos.op.core.jpa.IBaseRepository;

@Repository("iTopographyLineDao")
public interface ITopographyLineRepository extends IBaseRepository<TopographyLine, String> {

	@Query(value="select * from b_topography_line where org_code like concat(?1,'%') and treeid =?2 and type =?3",nativeQuery=true )
	List<TopographyLine> findByOrgCodeAndTreeidAndType(String orgcode,String treeid, int type);
	@Query(value="select * from b_topography_line where org_code like concat(?1,'%') and type =?2",nativeQuery=true )
	List<TopographyLine> findByOrgCodeAndType(String orgcode,int type);

	TopographyLine findByFromAndToAndTreeid(String from, String to, String treeid);
}
