package com.yeejoin.amos.bank.dao.repository;

import java.util.List;

import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import com.yeejoin.amos.bank.TopographyTree;
import com.yeejoin.amos.op.core.jpa.IBaseRepository;

@Repository("iTopographyTreeDao")
public interface ITopographyTreeRepository extends IBaseRepository<TopographyTree, String> {
	@Query(value="select * from b_topography_tree where  type =?1  and org_code  like concat(?2,'%') ",nativeQuery=true )
	List<TopographyTree> findByTypeAndOrgCode(int type,String orgCode);
	
	TopographyTree findByCodeAndType(String code, int type);
	
	List<TopographyTree> findByType(int type);
}
