package com.yeejoin.amos.bank.remote;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.bank.common.enums.DeviceUriEnum;
import com.yeejoin.amos.bank.remote.client.DeviceRemoteClient;
import com.yeejoin.amos.bank.utils.HttpUtil;
import com.yeejoin.amos.component.feign.config.InnerInvokException;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import com.google.common.collect.Maps;
import java.util.Map;

@Service
public class RemoteAlarmTiggerService {

    private static final Logger log = org.apache.log4j.Logger.getLogger(RemoteAlarmTiggerService.class);


//    @Value("${params.deviceTrigger.address}")
//    private String address;
    
    @Value("${params.deviceTrigger.address}")
    private String triggerAlarmUrl;

    @Autowired
    private DeviceRemoteClient deviceRemoteClient;

    private String buildUrl(String address, DeviceUriEnum deviceUriEnum, Map<String, String> map) {
        String uri = deviceUriEnum.getUri();
        String params = deviceUriEnum.getParams();
        if (!StringUtils.isEmpty(params) && map != null) {
            String[] paramsArr = params.split(",");
            for (String param : paramsArr) {
                uri = uri.replace("{" + param + "}", map.get(param));
            }
        }
        return address + uri;
    }

//    public String alarmTiggerGet(DeviceUriEnum deviceUriEnum, String token, Map<String, String> params) {
//        String url = buildUrl(address, deviceUriEnum, params);
//        return HttpUtil.doGet(url);
//    }

	public String sendAlarm(String xmlData) {
        try {
        	Map<String, String> params =  Maps.newHashMap();
    		params.put("xmlData", xmlData);
        	String result = alarmTiggerGet(DeviceUriEnum.触发清除告警,null,params);
           // Object result = deviceRemoteClient.sendAlarm(xmlData);
            return JSON.toJSONString(result);
        } catch (Exception e) {
            log.error("sendAlarm fail " + e.getMessage());
        }
        return null;
    }
    
	public String alarmTiggerGet(DeviceUriEnum deviceUriEnum, String token ,Map<String, String> params) {
		String url = buildUrl(triggerAlarmUrl, deviceUriEnum, params);
		return HttpUtil.doGet(url);
	}
}
