package com.yeejoin.amos.bank.service;

import java.util.List;
import java.util.Map;

import com.yeejoin.amos.bank.TopographyTree;
import com.yeejoin.amos.bank.dto.TopographyEventDTO;
import com.yeejoin.amos.bank.dto.TopographyLineDTO;
import com.yeejoin.amos.bank.dto.TopographyNodeDTO;
import com.yeejoin.amos.bank.dto.TopographyTreeDTO;
import com.yeejoin.amos.bank.param.AbnormalParam;
import com.yeejoin.amos.op.core.jpa.IGenericManager;

/**
 * 拓扑图service
 *
 * @author zhangzhihui
 */
public interface ITopographyService extends IGenericManager<TopographyTree, String> {

	List<TopographyTreeDTO> getTree(String orgcode,int type);

	List<TopographyNodeDTO> getNodes(String orgcode,String treeid, int type);

	List<TopographyLineDTO> getLinks(String orgcode,String treeid, int type);

	void saveNodes(String orgcode,List<TopographyNodeDTO> nodeData);

	List<TopographyEventDTO> getEvents();

	void testAbnormal(AbnormalParam param) throws Exception;
	
	void delWebTree(String treeid);

	void addWebTree(TopographyTreeDTO tree);

	Object getNodeDetail(String id);

	void sendAbnormal(String sourceId, int state);
	
	void sendAbnormalByType(String sourceId, int state, int type, String nodeDetailItem);
	
	List<Map> getDeviceNodes(String orgcode);

	List<TopographyLineDTO> getDeviceLinks(String orgcode);

	void sendPMTSAbnormal(String fromSourceId, String toSourceId, String groupName, Long treeId, int state);
	
    public String getSelfOrgCode();

}
