package com.yeejoin.amos.bank.service.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yeejoin.amos.bank.common.enums.PaymentEnum;
import com.yeejoin.amos.bank.entity.planTaskReturn;
import com.yeejoin.amos.bank.entity.pointReturn;
import com.yeejoin.amos.bank.service.InspectionService;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.spc.business.dao.mapper.InputItemMapper;
import com.yeejoin.amos.spc.business.dao.mapper.StatisticsMapper;
import com.yeejoin.amos.spc.business.remote.RemoteSecurityService;
import com.yeejoin.amos.spc.business.service.impl.SpcSecurityServiceImpl;
import com.yeejoin.amos.spc.core.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.*;

@Service
public class InspectionServiceImpl implements InspectionService {

    @Autowired
    private StatisticsMapper statisticsMapper;

    @Autowired
    private SpcSecurityServiceImpl securityService;

    @Autowired
    private InputItemMapper inputMapper;
    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Override
    public List<HashMap<String, Object>> queryRightTopChart(String companyId) {
    	
    	
    	List<DepartmentModel>   com=securityService.listDepartmentTree(companyId);
//    	String departmentid=null;
//    	if(com!=null){
//    		
//    		Map<String, Object> json=(Map<String, Object>) com;
//    		Map<String, Object> department=(Map<String, Object>)json.get("department");
//    		departmentid=department.get("sequenceNbr")+"";
//    	}
//     	
////        List<DepartmentModel> listDepartments = securityService.listDepartmentTree(companyID);
//    	 List<DepartmentModel> listDepartments = securityService.querySubAgencyTree(departmentid);
    	
    	 List<LinkedHashMap> listDepartments =new ArrayList<LinkedHashMap>();
    	  if(com!=null&&com.size()>0){
    		  //获取二级部门
    		  com.forEach(e -> {   			  
    			  List<LinkedHashMap> ch=  (List<LinkedHashMap>) e.getChildren();
    			  if(ch!=null&&ch.size()>0){   				  
    				  ch.forEach(a -> {  					  
    					  listDepartments.add(a);
    				  });
    			  }
    			  
    		  });
    		  
    	  }
        HashMap<String, Object> depMap = new HashMap<String, Object>();
        List<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
         //未开始
         List wks=new ArrayList();
         //运行中
         List yxz=new ArrayList();
         //已结束
         List yjs=new ArrayList();
         //已超时
         List ycs=new ArrayList();
         //x
         List x=new ArrayList();
         if(listDepartments!=null&&listDepartments.size()>0){
        listDepartments.forEach(
                e -> {         
                	int num=0;
                        HashMap<String, Object> rightTopChartData = statisticsMapper.queryRightTopChartDataByDepId(e.get("orgCode").toString());
                        if (rightTopChartData == null) {
                        	wks.add(0);
                        	yxz.add(0);
                        	yjs.add(0);
                        	ycs.add(0);
                         }else{                       	
						wks.add(rightTopChartData.get("noStartNum" ));
						yxz.add( rightTopChartData.get("noPassNum"));
						yjs.add(rightTopChartData.get("passNum"));
						ycs.add(rightTopChartData.get("overTimeNum"));
						num=Integer.valueOf(rightTopChartData.get("noStartNum" ).toString())+
								Integer.valueOf(rightTopChartData.get("noPassNum" ).toString())+
								Integer.valueOf(rightTopChartData.get("passNum" ).toString())+
								Integer.valueOf(rightTopChartData.get("overTimeNum" ).toString());
                        }                      
                        x.add(e.get("departmentName"));
                        depMap.put(e.get("departmentName").toString(), e.get("orgCode").toString());
                        depMap.put(e.get("orgCode").toString(), num);
                }
        );
    }
         
         
         depMap.put("wks", wks);
         depMap.put("yxz", yxz);
         depMap.put("yjs", yjs);
         depMap.put("ycs", ycs);
         depMap.put("x", x);
         list.add(depMap);
        return list;
    }

    @Override
    public HashMap<String, Object> queryBottomTableData() {

        List<String> enumCodesList = PaymentEnum.getEnumCodesList();
        List<HashMap<String, Object>> list = inputMapper.queryPaymentByCodes(enumCodesList);

        List<HashMap<String, Object>> ljlrjy = new ArrayList<>();
        List<HashMap<String, Object>> ljlcjy = new ArrayList<>();
        List<HashMap<String, Object>> ljlrjyje = new ArrayList<>();
        List<HashMap<String, Object>> ljlcjyje = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (HashMap<String, Object> m : list) {
                String itemNo = (String) m.get("item_no");
                if (PaymentEnum.流入笔数.getCode().equals(itemNo)) {
                    ljlrjy.add(m);
                } else if (PaymentEnum.流出笔数.getCode().equals(itemNo)) {
                    ljlcjy.add(m);
                } else if (PaymentEnum.流入金额.getCode().equals(itemNo)) {
                    Double score = StringUtil.getNumToDouble(m.get("score").toString());
                    m.put("score", score);
                    ljlrjyje.add(m);
                } else {
                    Double score = StringUtil.getNumToDouble(m.get("score").toString());
                    m.put("score", score);
                    ljlcjyje.add(m);
                }
            }
        }
        HashMap<String, Object> data = new HashMap<>();
        data.put(PaymentEnum.流入笔数.getCode(), ljlrjy);
        data.put(PaymentEnum.流出笔数.getCode(), ljlcjy);
        data.put(PaymentEnum.流入金额.getCode(), ljlrjyje);
        data.put(PaymentEnum.流出金额.getCode(), ljlcjyje);
        return data;
    }


    @Override
    public Map<String, Object> queryRightTopChartlist(Integer pageIndex, Integer pageSize, String deptId, String deptName) {

        List<planTaskReturn> list = statisticsMapper.planTaskReturnliat(pageIndex, pageSize, deptId);
        List<planTaskReturn> listnum = statisticsMapper.planTaskReturnliat(null, null, deptId);
        int num = 0;

        if (listnum != null) {
            num = listnum.size();
        }

        Map<String, Object> map2 = new HashMap<>();
        Set<String> userIds = Sets.newHashSet();
        Map<String, AgencyUserModel> AgencyUserModelMap = null;
        list.forEach(m -> {
            if (m.getUserId() != null) {
                String[] staffs = m.getUserId().split(",");
                List staffsList = Arrays.asList(staffs);
                userIds.addAll(staffsList);
            }
        });
        if (userIds.size() > 0) {
            List<AgencyUserModel> AgencyUserModels = remoteSecurityService.listUserByUserIds(Joiner.on(",").join(userIds));
            AgencyUserModelMap = Maps.uniqueIndex(AgencyUserModels, AgencyUserModel::getUserId);
        }

        for (planTaskReturn map : list) {
            if (AgencyUserModelMap != null) {
                String[] staffs = map.getUserId().split(",");
                String nameu = "";
                if (staffs != null) {
                    for (int i = 0; i < staffs.length; i++) {
                        AgencyUserModel AgencyUserModel = AgencyUserModelMap.get(staffs[i]);
                        if (!ObjectUtils.isEmpty(AgencyUserModel)){
                            if (i == 0) {
                                nameu = nameu + AgencyUserModel.getRealName();
                            } else {
                                nameu = nameu + "," + AgencyUserModel.getRealName();
                            }
                        }
                    }
                }
                map.setUserId(nameu);
                map.setDeptName(deptName);
            }

            //查询点状态  
            String planTaskId = map.getPlanTaskId();
            List<pointReturn> listd = statisticsMapper.pointReturnlist(planTaskId);
            map.setPointReturn(listd);
        }

        map2.put("date", list);
        map2.put("num", num);

        return map2;
    }

	@Override
	public HashMap<String, Object> getporint(String pointid) {
		HashMap<String, Object> listd = statisticsMapper.getporint(pointid);
		return listd;
	}

	@Override
	public HashMap<String, Object> getporintdate(String pointid) {
		HashMap<String, Object> listd = statisticsMapper.getporintdate(pointid);
		return listd;
	}
}
