package com.yeejoin.amos.bank.service.impl;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.bank.dao.PatrolRouteDao;
import com.yeejoin.amos.bank.entity.PatrolRoute;
import com.yeejoin.amos.bank.service.PatrolRouteService;
import com.yeejoin.amos.bank.utils.HttpUtil;
import com.yeejoin.amos.bank.webSocket.AmosWsClient;
import com.yeejoin.amos.bank.webSocket.WebsocketParam;
import com.yeejoin.amos.op.core.jpa.GenericManagerImpl;
import com.yeejoin.amos.op.core.jpa.IBaseRepository;

import java.util.Properties;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.stereotype.Service;

/**
 * @Author: xinglei
 * @Description:
 * @Date: 2019/12/10 16:53
 */
@Service("patrolRouteService")
public class PatrolRouteServiceImpl extends GenericManagerImpl<PatrolRoute, Long> implements PatrolRouteService {
    public PatrolRouteServiceImpl(IBaseRepository<PatrolRoute, Long> repository) {
        super(repository);
    }

    private static final Logger log = org.apache.log4j.Logger.getLogger(PatrolRouteServiceImpl.class);

    @Autowired
    private AmosWsClient client;

    @Autowired
    private PatrolRouteDao dao;

    @Override
    public boolean add(PatrolRoute patrolRoute) {
        try {
            dao.save(patrolRoute);
            WebsocketParam param = new WebsocketParam("gj", JSON.toJSONString(patrolRoute));
            //client.sendMessage(param);
            Properties props = PropertiesLoaderUtils.loadAllProperties("application.properties");
            String url = (String) props.get("params.remoteWebsocketUrl") + "/generic/sendMessage";
            HttpUtil.PostJson(url, JSON.toJSONString(param));
            return true;
        } catch (Exception e) {
            log.error("保存失败: ");
            e.printStackTrace();
            return false;
        }
    }
}
