package com.yeejoin.amos.bank.utils;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;

/**
 * @Author: xinglei
 * @Description:
 * @Date: 2020/6/10 16:31
 */
public class DateTimeKit {

    public static final String PATTERN_DEFAULT = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_FULL = "yyyy-MM-dd HH:mm:ss SSS";
    public static final String PATTERN_DATE = "yyyy-MM-dd";
    public static final String PATTERN_TIME = "HH:mm:ss";
    public static final String PATTERN_SEQUENCE = "yyyyMMddHHmmssSSS";

    public DateTimeKit() {
    }

    public static String format(ZonedDateTime dateTime) {
        return format(dateTime, "yyyy-MM-dd HH:mm:ss");
    }

    public static String format(ZonedDateTime dateTime, String pattern) {
        return dateTime == null ? null : dateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String now() {
        return format(ZonedDateTime.now());
    }

    public static String getSubtract(String date) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(PATTERN_DEFAULT).withZone(ZoneId.of("Asia/Shanghai"));
        ZonedDateTime startTime = ZonedDateTime.parse(date, dateTimeFormatter);
        long day = ChronoUnit.DAYS.between(startTime, ZonedDateTime.now());
        long hour = ChronoUnit.HOURS.between(startTime, ZonedDateTime.now());
        long minute = ChronoUnit.MINUTES.between(startTime, ZonedDateTime.now());
        StringBuffer sb = new StringBuffer();
        if (day != 0) {
            sb.append(day).append("天");
        }
        if (hour != 0) {
            sb.append(hour % 24).append("小时");
        }
        if (minute != 0) {
            sb.append(minute % 60).append("分");
        }
        return sb.toString();
    }
}
