package com.yeejoin.amos.bank.utils;

import java.nio.charset.StandardCharsets;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import com.yeejoin.amos.bank.entity.DeviceBean;
import com.yeejoin.amos.bank.entity.H5Response;
import com.yeejoin.amos.bank.entity.Video;

@Service("videoRemoteServer")
public class VideoRemoteServer {

	private static final Logger logger = Logger.getLogger(VideoRemoteServer.class);
	
	private String address;
	
	@Resource(name = "paramsConfig")
	private ParamsConfig paramsConfig;
	
	private final RestTemplate restTemplate;
	
	@Autowired
	protected HttpServletRequest request;
	
	public VideoRemoteServer() {
		this.restTemplate = new RestTemplate();
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	
	public H5Response addDevice(Video bean) {
		//String url = paramsConfig.getRemoteurl();
		StringBuilder sb = new  StringBuilder();
		sb.append(paramsConfig.getRemoteurl()).append("/api/v1/AddSrcRTSP?name=").append(bean.getName())
		.append('&').append("user=").append(bean.getUser())
		.append('&').append("password=").append(bean.getPassword())
		.append('&').append("token=").append(bean.getToken())
		.append('&').append("playback=").append(false)
		.append('&').append("audio=").append(true)
		.append('&').append("session=").append("c1782caf-b670-42d8-ba90-2244d0b0ee83")
		.append('&').append("url=").append(bean.getRtspAddress());
		
		HttpHeaders headers = new HttpHeaders();
		MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
		headers.setContentType(type);
		headers.add("Accept", MediaType.APPLICATION_JSON.toString());
		headers.add("X-From-Service", "true");
		restTemplate.getMessageConverters().set(1,new StringHttpMessageConverter(StandardCharsets.UTF_8));
		ResponseEntity<H5Response> responseEntity = restTemplate.getForEntity(sb.toString(), H5Response.class,headers);
		return responseEntity.getBody();
	}
	
	public DeviceBean getDevice(String token) {
		StringBuilder sb = new  StringBuilder();
		sb.append(paramsConfig.getRemoteurl()).append("/api/v1/GetSrc?token=").append(token).append('&').append("session=").append("c1782caf-b670-42d8-ba90-2244d0b0ee83");
		HttpHeaders headers = new HttpHeaders();
		MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
		headers.setContentType(type);
		headers.add("Accept", MediaType.APPLICATION_JSON.toString());
		headers.add("X-From-Service", "true");
		restTemplate.getMessageConverters().set(1,new StringHttpMessageConverter(StandardCharsets.UTF_8));
		ResponseEntity<DeviceBean> responseEntity = restTemplate.getForEntity(sb.toString(), DeviceBean.class,headers);
		return responseEntity.getBody();
	}
	
	public H5Response deleteDevice(String token) {
		StringBuilder sb = new  StringBuilder();
		sb.append(paramsConfig.getRemoteurl()).append("/api/v1/DelSrc?token=").append(token).append('&').append("session=").append("c1782caf-b670-42d8-ba90-2244d0b0ee83");
		HttpHeaders headers = new HttpHeaders();
		MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
		headers.setContentType(type);
		headers.add("Accept", MediaType.APPLICATION_JSON.toString());
		headers.add("X-From-Service", "true");
		restTemplate.getMessageConverters().set(1,new StringHttpMessageConverter(StandardCharsets.UTF_8));
		ResponseEntity<H5Response> responseEntity = restTemplate.getForEntity(sb.toString(), H5Response.class,headers);
		return responseEntity.getBody();
	}
}