package com.yeejoin.amos.bank.webSocket;

import java.util.ArrayList;
import java.util.List;

/**
 * 通用websocket发送对象数组传递参数
 * @author zhangzhihui
 *
 */
public class WebsocketListParam {

	/**
	 * websocket路径，例如：ws://127.0.0.1:10600/zq?orgCode=1*2*3  中的zq
	 */
	private String path;
	
	/**
	 * 发送消息对象数组
	 */
	private List<?> dataList;
	
	/**
	 * 过滤条件，根据哪些属性进行过滤
	 */
	private List<String> filterAttributes;

	public WebsocketListParam() {
		super();
	}

	public WebsocketListParam(String path, List<?> dataList) {
		super();
		this.path = path;
		this.dataList = dataList;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public List<?> getDataList() {
		return dataList;
	}

	public void setDataList(List<?> dataList) {
		this.dataList = dataList;
	}

	public List<String> getFilterAttributes() {
		return filterAttributes;
	}

	public void setFilterAttributes(List<String> filterAttributes) {
		this.filterAttributes = filterAttributes;
	}

	public WebsocketListParam addFilter(String attr){
		if(filterAttributes == null){
			filterAttributes = new ArrayList<>();
		}
		filterAttributes.add(attr);
		return this;
	}
}
