package com.yeejoin.amos.spc.business.controller;

import com.yeejoin.amos.spc.business.dao.mapper.ExcelMapper;
import com.yeejoin.amos.spc.common.enums.ExcelModelEnum;
import com.yeejoin.amos.spc.core.excel.EquipmentExcel;
import com.yeejoin.amos.spc.core.excel.RiskPointExcel;
import com.yeejoin.amos.spc.core.excel.RiskRegionListExcel;
import com.yeejoin.amos.spc.core.excel.RiskSourceListOfEquipmentExcel;
import com.yeejoin.amos.spc.core.excel.RiskSourceListOfTaskworkExcel;
import com.yeejoin.amos.spc.core.excel.SeriousRiskListExcel;
import com.yeejoin.amos.spc.core.excel.TaskworkExcel;
import com.yeejoin.amos.spc.core.util.FileHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@RestController
@RequestMapping(value = "/api/excel")
@Api(tags = "风险清单相关")
public class ExcelController extends BaseController {

    private final Logger logger = LoggerFactory.getLogger(ExcelController.class);

    @Autowired
    private ExcelMapper excelMapper;

    @ApiOperation(value = "导出excel数据", notes = "导出excel数据")
    @GetMapping(value = "/export")
    public void exportExcel(HttpServletResponse response,
                            @ApiParam(value = "模型名称", required = true) @RequestParam String modelName,
                            @ApiParam(value = "查询条件") @RequestBody(required = false) Map<String, Object> queryMap) {
        try {
            ExcelModelEnum modelEnum = ExcelModelEnum.getByCode(modelName);
            if (modelEnum == null) {
                return;
            }
            Class cls = null;
            List<?> list = null;
            switch (modelEnum) {
                case 作业活动:
                    list = excelMapper.exportTaskworkExcel(queryMap);
                    cls = TaskworkExcel.class;
                    break;
                case 设备设施:
                    list = excelMapper.exportEquipmentExcel(queryMap);
                    cls = EquipmentExcel.class;
                    break;
                case 风险点清单:
                    list = excelMapper.exportRiskPointExcel(queryMap);
                    cls = RiskPointExcel.class;
                    break;
                case 重大安全风险及控制措施清单:
                    list = excelMapper.exportSeriousRiskListExcel(queryMap);
                    cls = SeriousRiskListExcel.class;
                    break;
                case 危险源作业活动及控制措施清单:
                    list = excelMapper.exportRiskSourceListOfTaskworkExcel(queryMap);
                    cls = RiskSourceListOfTaskworkExcel.class;
                    break;
                case 危险源设备设施及控制措施清单:
                    list = excelMapper.exportRiskSourceListOfEquipmentExcel(queryMap);
                    cls = RiskSourceListOfEquipmentExcel.class;
                    break;
                case 风险区域清单:
                    list = excelMapper.exportRiskRegionListExcel(queryMap);
                    cls = RiskRegionListExcel.class;
                    break;
                default:
                    break;
            }
            String fileName = UUID.randomUUID().toString() + ".xls";
            FileHelper.exportExcel(list, modelEnum.getName(), modelEnum.getName(), cls, fileName + ".xls", response);
        } catch (Exception e) {
            logger.error("导出excel异常", e);
        }
    }

//    @ApiOperation(value = "导入excel数据", notes = "导入excel数据")
//    @PostMapping(value = "/import")
//    @Authorization(ingore = true)
//    public void importExcel(@RequestPart("file") MultipartFile file,
//                            @ApiParam(value = "模板名称", required = true) @RequestParam String modelName) {
//        InputStream inputStream = null;
//        try {
//            ExcelJsonBo excelJsonBo = ExcelJsonUtil.readJsonByModelName(modelName);
//            if (excelJsonBo == null) {
//                return;
//            }
//            inputStream = file.getInputStream();
//            Map<String, String> map = Maps.newHashMap();
//            map.put("org_code", "1");
//            String tableName = excelJsonBo.getTableName();
//            List<List<ShowColumnsBo>> data = ExcelUtil.readExcel(inputStream, modelName, excelJsonBo.getShowColumns(), map);
//            for (List<ShowColumnsBo> columns : data) {
//                String sql = ExcelJsonUtil.buildInsertSql(tableName, columns);
//                excelMapper.insertOne(sql);
//            }
//        } catch (Exception e) {
//            logger.error("导入excel异常", e);
//        } finally {
//            if (inputStream != null) {
//                try {
//                    inputStream.close();
//                } catch (Exception e) {
//
//                }
//            }
//        }
//    }
}
