package com.yeejoin.amos.spc.business.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.service.intfc.ISpcRiskSourceService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "/api/rule")
@Api(tags = "规则预案管理")
public class RuleController extends BaseController 
{

    @Autowired
    private ISpcRiskSourceService riskSourceService;

    @ApiOperation(httpMethod = "PUT",value = "触发设备报警规则", notes = "触发设备报警规则")
    @RequestMapping(value = "/fire/{equipId}", produces = "application/json;charset=UTF-8", method = RequestMethod.PUT)
    public CommonResponse fireRule(@ApiParam(value = "设备id", required = true, defaultValue = "1159") @PathVariable String equipId)  throws Exception{

        return CommonResponseUtil.success(riskSourceService.processFireEqumtData(equipId));
    }

}
