package com.yeejoin.amos.spc.business.controller;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.param.ReginParams;
import com.yeejoin.amos.spc.business.remote.RemoteSecurityService;
import com.yeejoin.amos.spc.business.service.intfc.ISpcControlMeasureService;
import com.yeejoin.amos.spc.common.enums.DictTypeEnum;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.common.request.CommonRequest;
import com.yeejoin.amos.spc.dao.entity.SpcControlMeasure;
import com.yeejoin.amos.spc.exception.YeeException;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "api/spcControlMeasure")
@Api(tags = "控制措施管理")
public class SpcControlMeasureController extends BaseController {
    private final Logger log = LoggerFactory.getLogger(SpcControlMeasureController.class);
    
    @Autowired
    private ISpcControlMeasureService iSpcControlMeasuresService;
    
    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @ApiOperation(httpMethod = "POST", value = "分页查询", notes = "分页查询")
    @RequestMapping(value = "pagelist", method = RequestMethod.POST)
    public CommonResponse getTableList(@ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests,
                                       @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        List<DaoCriteria> criterias = buildDaoCriterias(queryRequests);
//        ReginParams reginParams = getSelectedOrgInfo();//公共数据，不用按照org_code过滤，20191105
//        DaoCriteria compDaoCriteria = new DaoCriteria();
//        compDaoCriteria.setPropertyName("orgCode");
//        compDaoCriteria.setOperator(QueryOperatorEnum.EQUAL.getName());
//        compDaoCriteria.setValue(getLoginOrgCode(reginParams));
//        criterias.add(compDaoCriteria);
        Page<SpcControlMeasure> list = iSpcControlMeasuresService.queryEntryByCondition(criterias, commonPageable);
        return CommonResponseUtil.success(list);
    }

    @ApiOperation(httpMethod = "GET", value = "明细查询", notes = "明细查询")
    @RequestMapping(value = "getDetailById/{id}", method = RequestMethod.GET)
    public CommonResponse getTableList(@PathVariable(name = "id") Long id) {
        SpcControlMeasure datail = iSpcControlMeasuresService.getDetailById(id);
        return CommonResponseUtil.success(datail);
    }

    /**
     * 控制措施管理新增及编辑
     */
    @ApiOperation(httpMethod = "POST", value = "新增及编辑", notes = "新增及编辑")
    @RequestMapping(value = "/save", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse SpcControlMeasuresEdit(@ApiParam(value = "后果实体类", required = true) @RequestBody SpcControlMeasure entry) {
        try {
        	List<SpcControlMeasure> controlMeasures = iSpcControlMeasuresService.queryControlMeasureByName(entry.getName());
        	if(null != entry.getId()) {//为编辑时过滤自己
        		controlMeasures = controlMeasures.stream().filter(e -> e.getId() != entry.getId()).collect(Collectors.toList());
        	}
        	if(controlMeasures != null && controlMeasures.size() > 0) {
        		return CommonResponseUtil.failure("管控措施已存在");
        	}
            ReginParams reginParams = getSelectedOrgInfo();
            entry.setCreatorId(getUserId());
            entry.setOrgCode(getLoginOrgCode(reginParams));
            entry.setUpdateDate(new Date());
            iSpcControlMeasuresService.saveEntry(entry,getToken());
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("新增失败");
        }
    }

    /**
     * 控制措施管理删除（支持批量）
     */
    @ApiOperation(httpMethod = "POST", value = "控制措施管理删除", notes = "控制措施管理删除")
    @RequestMapping(value = "/delEntryByIds", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse deletePlanById(
            @ApiParam(value = "id数组", required = true) @RequestBody String[] param) {
        try {
            iSpcControlMeasuresService.delEntryById(param);
            return CommonResponseUtil.success();
        } catch (YeeException e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure(e.getMessage());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("控制措施管理删除失败");
        }
    }
    
    /**
     * 获取管控措施类型
     *
     * @return
     */
    @ApiOperation(httpMethod = "GET", value = "获取管控措施类型", notes = "获取管控措施类型")
    @GetMapping(value = "/types", produces = "application/json;charset=UTF-8")
    public CommonResponse getType() {
        return CommonResponseUtil.success(remoteSecurityService.getDictValues(DictTypeEnum.controlMeasuresType.getCode()));
    }
    
    /**
     * 获取管控措施类别
     *
     * @return
     */
    @ApiOperation(httpMethod = "GET", value = "获取管控措施类别", notes = "获取管控措施类别")
    @GetMapping(value = "/categorys", produces = "application/json;charset=UTF-8")
    public CommonResponse getCategory() {
        return CommonResponseUtil.success(remoteSecurityService.getDictValues(DictTypeEnum.controlMeasuresCategory.getCode()));
    }

}
